/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class MultiDeltaSpecification
implements Serializable {
    private final DeltaSpecification mainDeltaSpecification;
    private final List<DeltaSpecification> deltaSpecifications;

    public MultiDeltaSpecification(DeltaSpecification deltaSpecification) {
        this(deltaSpecification, Collections.singletonList(deltaSpecification));
    }

    private MultiDeltaSpecification(DeltaSpecification mainDeltaSpecification, Iterable<DeltaSpecification> deltaSpecifications) {
        Preconditions.checkArgument((!Iterables.isEmpty(deltaSpecifications) ? 1 : 0) != 0, (Object)"Wrong usage of internal API: deltaSpecifications must not be empty");
        Preconditions.checkNotNull((Object)mainDeltaSpecification, (Object)"Wrong usage of internal API: mainDeltaSpecification must not be null");
        this.deltaSpecifications = Lists.newArrayList(deltaSpecifications);
        this.mainDeltaSpecification = mainDeltaSpecification;
    }

    public Operation getMainOperation() {
        return this.getMainDeltaSpecification().getOperation();
    }

    public DeployedApplication getMainDeployedApplication() {
        return this.getMainDeltaSpecification().getDeployedApplication();
    }

    public DeployedApplication getMainPreviousDeployedApplication() {
        return this.getMainDeltaSpecification().getPreviousDeployedApplication();
    }

    public DeltaSpecification getMainDeltaSpecification() {
        return this.mainDeltaSpecification;
    }

    public List<DeltaSpecification> getDeltaSpecifications() {
        return Collections.unmodifiableList(this.deltaSpecifications);
    }

    public List<DeployedApplication> getAllDeployedApplications() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getDeltaSpecifications(), (Function)new Function<DeltaSpecification, DeployedApplication>(){

            @Nullable
            public DeployedApplication apply(DeltaSpecification input) {
                return input.getDeployedApplication();
            }
        }));
    }

    public List<Delta> getAllDeltas() {
        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform(this.getDeltaSpecifications(), (Function)new Function<DeltaSpecification, Iterable<Delta>>(){

            @Nullable
            public Iterable<Delta> apply(DeltaSpecification input) {
                return input.getDeltas();
            }
        })));
    }

    public static MultiDeltaSpecification withDependencies(DeltaSpecification main, List<DeltaSpecification> required) {
        return new MultiDeltaSpecification(main, Iterables.concat(required, Collections.singletonList(main)));
    }

    public static MultiDeltaSpecification forRollback(List<DeltaSpecification> deltaSpecifications) {
        return new MultiDeltaSpecification(deltaSpecifications.get(0), deltaSpecifications);
    }
}

