package com.xebialabs.deployit.deployment.planner;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.xld.AppliedDistribution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.unmodifiableList;

@SuppressWarnings("serial")
public class DefaultDeltaSpecification implements DeltaSpecification, Serializable {

    private boolean rollback;
    private Operation operation;
    private AppliedDistribution previousDeployedApplication;
    private AppliedDistribution deployedApplication;
    private List<Delta> deltas;

    public DefaultDeltaSpecification(Operation operation, AppliedDistribution previousDeployedApplication, AppliedDistribution deployedApplication, List<Delta> deltas, boolean rollback) {
        this(operation, previousDeployedApplication, deployedApplication, deltas);
        this.rollback = rollback;
    }

    public DefaultDeltaSpecification(Operation operation, AppliedDistribution previousDeployedApplication, AppliedDistribution deployedApplication, List<Delta> deltas) {
        this.operation = operation;
        this.previousDeployedApplication = previousDeployedApplication;
        this.deployedApplication = deployedApplication;
        ArrayList<Delta> deltas1 = newArrayList(deltas);
        Collections.sort(deltas1, (delta, delta1) -> {
            Deployed d1 = delta.getOperation() != Operation.DESTROY ? delta.getDeployed() : delta.getPrevious();
            Deployed d2 = delta1.getOperation() != Operation.DESTROY ? delta1.getDeployed() : delta1.getPrevious();
            return d1.getName().compareTo(d2.getName());
        });
        this.deltas = unmodifiableList(deltas1);
    }

    @Override
    public Operation getOperation() {
        return operation;
    }

    @Override
    public AppliedDistribution getPreviousAppliedDistribution() {
        return previousDeployedApplication;
    }

    @Override
    public AppliedDistribution getAppliedDistribution() {
        return deployedApplication;
    }

    @Override
    public DeployedApplication getPreviousDeployedApplication() {
        return castOrThrow(getPreviousAppliedDistribution());
    }

    @Override
    public DeployedApplication getDeployedApplication() {
        return castOrThrow(getAppliedDistribution());
    }

    private DeployedApplication castOrThrow(AppliedDistribution appliedDistribution) {
        if (appliedDistribution == null || appliedDistribution instanceof DeployedApplication) {
            return (DeployedApplication) appliedDistribution;
        } else {
            throw new UnsupportedOperationException(
                    "This delta specification does not represent a deployment operation (probably a provisioning operation). " +
                            "The type found is not com.xebialabs.deployit.plugin.api.udm.DeployedApplication, but " + appliedDistribution.getClass() + ". " +
                            "Please use 'get(Previous)AppliedDistribution' instead of 'get(Previous)DeployedApplication' from a code context or 'deployedApplication'/'previousDeployedApplication' from a script context.");
        }
    }

    @Override
    public List<Delta> getDeltas() {
        return deltas;
    }

    public boolean isRollback() {
        return rollback;
    }
}
