package com.xebialabs.deployit.deployment.planner

import com.xebialabs.deployit.deployment.planner.PlanSugar._
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.services.Repository

import scala.collection.convert.wrapAll._

class SimplifyingDeploymentPlanner(wrappedPlanner: Planner) extends Planner with PlanSugar {

  def plan(spec: DeltaSpecification, repository: Repository): PhasedPlan = {
    val complexPlan = wrappedPlanner.plan(spec, repository)
    if (spec.getAppliedDistribution.isOptimizePlan) {
      simplify(complexPlan)
    } else {
      complexPlan
    }
  }

  def simplify(complexPlan: Plan): PhasedPlan = {
    complexPlan match {
      case phasedPlan: PhasedPlan => simplify(phasedPlan)
      case planPhase: PlanPhase => new PhasedPlan(List(simplify(planPhase)), planPhase.getListeners)
      case plan: ExecutablePlan => new PhasedPlan(List(new PlanPhase(simplify(plan), plan.getDescription, plan.getListeners)), plan.getListeners)
    }
  }

  def simplify(plan: ExecutablePlan): ExecutablePlan = plan match {
    case cp: CompositePlan if cp.getSubPlans.size() == 1 => simplify(cp.getSubPlans.get(0))
    case cp: CompositePlan => simplifyComposite(cp).getOrElse(cp.emptySteps())
    case p@_ => p
  }

  def simplify(phasedPlan: PhasedPlan): PhasedPlan = {
    phasedPlan.copy(phases = phasedPlan.phases.map(simplify))
  }

  def simplify(planPhase: PlanPhase): PlanPhase = {
    planPhase.copy(plan = simplify(planPhase.plan))
  }

  def simplifyComposite(plan: CompositePlan): Option[ExecutablePlan] = simplifySubplans(plan, plan.getClass) match {
    case Nil => None
    case head :: Nil => Some(head)
    case x@_ => Some(plan.copy(subPlans = x))
  }

  def simplifySubplans(plan: CompositePlan, cls: Class[_ <: CompositePlan]): List[ExecutablePlan] = plan.getSubPlans.collect({
    case p: Plan => simplify(p, cls)
  }).flatten.flatten.toList

  def simplify(plan: Plan, parentPlan: Class[_ <: CompositePlan]): Option[List[ExecutablePlan]] = plan match {
    case cp: CompositePlan if cp.getSubPlans.isEmpty => None
    case cp: CompositePlan if cp.getSubPlans.size() == 1 => simplify(cp.getSubPlans.get(0), parentPlan)
    case cp: CompositePlan if cp.getClass == parentPlan =>
      simplifySubplans(cp, parentPlan) match {
        case Nil => None
        case x@_ => Some(x)
      }
    case cp: CompositePlan => simplifyComposite(cp).map(p => List(p))
    case p: StepPlan if !p.getSteps.isEmpty => Some(List(p))
    case p: StepPlan => None
  }

}
