package com.xebialabs.deployit.deployment.rules

import com.xebialabs.deployit.deployment.planner.PlanSugar._
import com.xebialabs.deployit.deployment.planner._
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification
import com.xebialabs.deployit.plugin.api.services.Repository

import scala.collection.convert.wrapAll._

class FilterEmptyPhasePlanner(simplifiedPlanner: Planner) extends Planner with PlanSugar {

  override def plan(spec: DeltaSpecification, repository: Repository) = {
    val phasedPlan: PhasedPlan = simplifiedPlanner.plan(spec, repository)
    if (spec.getAppliedDistribution.isOptimizePlan) {
      val phases = phasedPlan.phases.flatMap(phase => removeEmptyPlan(phase.plan) match {
        case Some(plan) => Some(phase.copy(plan = plan))
        case _ => None
      })
      phasedPlan.copy(phases = phases)
    }
    else phasedPlan
  }

  private[this] def removeEmptyPlan(plan: ExecutablePlan): Option[ExecutablePlan] = plan match {
    case (stepPlan: StepPlan) => filterStepPlan(stepPlan)
    case (compositePlan: CompositePlan) => filterCompositePlan(compositePlan)
  }

  private[this] def filterCompositePlan(compositePlan: CompositePlan): Option[ExecutablePlan] = compositePlan.getSubPlans.flatMap(plan => removeEmptyPlan(plan)) match {
    case subPlans if subPlans.nonEmpty => Option(compositePlan.copy(subPlans = subPlans))
    case _ => None
  }

  private[this] def filterStepPlan(step: StepPlan): Option[StepPlan] = {
    if (step.getSteps.nonEmpty) Some(step)
    else None
  }

}
