package com.xebialabs.deployit.deployment.planner

import java.io.Writer
import java.util.{List => juList}

import com.xebialabs.deployit.deployment.planner.StepPlan.Checkpoint
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener

class PlanPhase(val plan:ExecutablePlan, description: String, listeners: juList[ExecutionStateListener], val alwaysExecuted: Boolean) extends Plan(description, listeners) {

  def this(plan:ExecutablePlan, description: String, listeners: juList[ExecutionStateListener]) {
    this(plan, description, listeners, false)
  }

  override def writePlan(writer: Writer) = {
    writer.append("# [Plan phase] " + this.getDescription)
    plan.writePlan(writer)
  }

  override def findCheckpoints(): juList[Checkpoint] = {
    plan.findCheckpoints()
  }
}
