/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.inspection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectionContext
implements InspectionExecutionContext,
InspectionPlanningContext,
DeploymentExecutionContext {
    private ExecutionContext context;
    private Map<String, Object> attributes;
    private Logger stepLogger;
    private List<InspectionStep> steps = Lists.newArrayList();
    private AtomicInteger currentStepIndex = new AtomicInteger(0);
    private Map<String, ConfigurationItem> discovered = Maps.newHashMap();
    private Map<String, ConfigurationItem> inspected = Maps.newHashMap();
    private List<String> capturedError = Lists.newArrayList();
    private static Logger logger = LoggerFactory.getLogger(InspectionContext.class);

    public InspectionContext(ExecutionContext context) {
        this.context = (ExecutionContext)Preconditions.checkNotNull((Object)context);
    }

    public InspectionContext(Map<String, Object> attributes) {
        this.attributes = (Map)Preconditions.checkNotNull(attributes);
    }

    public void startStepExecution(InspectionStep step2) {
        if (this.attributes != null) {
            this.stepLogger = LoggerFactory.getLogger(step2.getClass());
        }
    }

    public void startStepExecution(Step step2) {
        if (this.attributes != null) {
            this.stepLogger = LoggerFactory.getLogger(step2.getClass());
        }
    }

    public void addStep(InspectionStep step2) {
        this.steps.add(step2);
    }

    public void discovered(ConfigurationItem item) {
        this.discovered.put(item.getId(), item);
    }

    public Map<String, ConfigurationItem> getDiscovered() {
        return this.discovered;
    }

    public void inspected(ConfigurationItem item) {
        if (this.discovered.remove(item.getId()) == null) {
            logger.warn(item + " has been inspected without being discovered");
        }
        this.inspected.put(item.getId(), item);
    }

    public Map<String, ConfigurationItem> getInspected() {
        return this.inspected;
    }

    public void logOutput(String output) {
        if (this.context != null) {
            this.context.logOutput(output);
        }
        if (this.stepLogger != null) {
            this.stepLogger.info(output);
        }
    }

    public void logError(String error) {
        if (this.context != null) {
            this.context.logError(error);
        }
        if (this.stepLogger != null) {
            this.stepLogger.error(error);
        }
        this.capturedError.add(error);
    }

    public void logError(String error, Throwable t) {
        if (this.context != null) {
            this.context.logError(error, t);
        }
        if (this.stepLogger != null) {
            this.stepLogger.error(error, t);
        }
        this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    public Object getAttribute(String name) {
        if (this.context != null) {
            return this.context.getAttribute(name);
        }
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        throw new IllegalStateException(this + " has no context and no attributes");
    }

    public void setAttribute(String name, Object object) {
        if (this.context != null) {
            this.context.setAttribute(name, object);
        }
        if (this.attributes != null) {
            this.attributes.put(name, object);
        }
    }

    public List<InspectionStep> getSteps() {
        return this.steps;
    }

    public InspectionStep getNextStep() {
        if (this.currentStepIndex.get() < this.steps.size()) {
            return this.steps.get(this.currentStepIndex.getAndIncrement());
        }
        return null;
    }

    public List<String> getCapturedError() {
        return this.capturedError;
    }
}

