package com.xebialabs.deployit.booter.remote.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.joda.time.DateTime;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;

public class RemoteTaskState implements TaskWithSteps {
    private TaskExecutionState state;
    private String id;
    private String description;
    private DateTime startDate;
    private DateTime completionDate;
    private int nrSteps;
    private List<Integer> currentStepNrs = new ArrayList<Integer>();
    private Map<String, String> metadata = new HashMap<String, String>();
    private int failureCount;
    private List<StepState> steps = new ArrayList<StepState>();
    private String owner;
    private DateTime scheduledDate;

    @Override
    public TaskExecutionState getState() {
        return state;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public DateTime getScheduledDate() {
        return scheduledDate;
    }

    @Override
    public DateTime getStartDate() {
        return startDate;
    }

    @Override
    public DateTime getCompletionDate() {
        return completionDate;
    }

    @Override
    public int getNrSteps() {
        return nrSteps;
    }

    /**
     * @deprecated Use {@link #getCurrentStepNrs()} instead.
     */
    @Override
    @Deprecated
    public int getCurrentStepNr() {
        int value = 0;
        if (currentStepNrs.size() > 0) {
            value = currentStepNrs.get(0);
        }
        return value;
    }

    @Override
    public List<Integer> getCurrentStepNrs() {
        return currentStepNrs;
    }

    @Override
    public Map<String, String> getMetadata() {
        return metadata;
    }

    @Override
    public int getFailureCount() {
        return failureCount;
    }

    @Override
    public String getOwner() {
        return owner;
    }

    @Override
    public List<StepState> getSteps() {
        return steps;
    }

    @Override
    public StepState getStep(int stepNr) {
        checkArgument(stepNr > 0 && stepNr <= steps.size(), "Not a valid step number [%s]", stepNr);
        return steps.get(stepNr - 1);
    }

    private static void checkArgument(boolean expression, String errorMessageTemplate, Object... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public void setState(TaskExecutionState state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public void setNrSteps(int nrSteps) {
        this.nrSteps = nrSteps;
    }

    /**
     * @deprecated Use {@link #setCurrentStepNrs(List)} instead.
     */
    @Deprecated
    public void setCurrentStepNr(int currentStepNr) {
        this.currentStepNrs = new ArrayList<Integer>(currentStepNr);
    }

    public void setCurrentStepNrs(List<Integer> currentStepNrs) {
        this.currentStepNrs = currentStepNrs;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String toString() {
        return id;
    }
}
