package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableFileArtifact;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

import java.io.Serializable;
import java.util.*;

import static com.google.common.collect.Lists.newArrayList;

public class RemoteDescriptor implements Descriptor, Serializable {
    private Type type;
    private String description;
    private boolean virtual;
    private boolean versioned = true;
    private Metadata.ConfigurationItemRoot root;
    private Map<String, PropertyDescriptor> propertyDescriptors = new LinkedHashMap<String, PropertyDescriptor>();
    private Map<String, MethodDescriptor> controlTasks = new LinkedHashMap<String, MethodDescriptor>();
    private List<Type> superTypes = new ArrayList<Type>();
    private Set<Type> interfaces = new HashSet<Type>();
    private Type deployableType;
    private Type containerType;
    private boolean inspectable;

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public Class<?> getClazz() {
        return BaseConfigurationItem.class;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRoot(Metadata.ConfigurationItemRoot root) {
        this.root = root;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public Metadata.ConfigurationItemRoot getRoot() {
        return root;
    }

    public void setPropertyDescriptors(Collection<PropertyDescriptor> propertyDescriptors) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
        }
    }

    @Override
    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return newArrayList(propertyDescriptors.values());
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String name) {
        return propertyDescriptors.get(name);
    }

    @Override
    public MethodDescriptor getControlTask(String name) {
        return controlTasks.get(name);
    }

    @Override
    public Collection<MethodDescriptor> getControlTasks() {
        return controlTasks.values();
    }

    public void setControlTasks(Collection<MethodDescriptor> methodDescriptors) {
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            this.controlTasks.put(methodDescriptor.getName(), methodDescriptor);
        }
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return isAssignableTo(Type.valueOf(clazz));
    }

    @Override
    public boolean isAssignableTo(Type type) {
        return this.type.isSubTypeOf(type) || this.type.equals(type);
    }

    public void setSuperTypes(List<Type> superTypes) {
        this.superTypes = superTypes;
    }

    @Override
    public List<Type> getSuperClasses() {
        return superTypes;
    }

    public void setInterfaces(Set<Type> interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public Set<Type> getInterfaces() {
        return interfaces;
    }

    public void setVirtual() {
        this.virtual = true;
    }

    @Override
    public boolean isVirtual() {
        return virtual;
    }

    public void setVersioned(boolean versioned) {
        this.versioned = versioned;
    }

    @Override
    public boolean isVersioned() {
        return versioned;
    }

    @Override
    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return false;
    }

    @Override
    public <T extends ConfigurationItem> T newInstance() {
        BaseConfigurationItem ci;
        if (isAssignableTo(Type.valueOf("udm.SourceArtifact"))) {
            ci = new BaseDeployableFileArtifact();
        } else if (isAssignableTo(Type.valueOf("udm.Parameters"))) {
            ci = new Parameters();
        } else {
            ci = new BaseConfigurationItem();
        }
        ci.setType(type);
        prefillDefaults(ci);
        return (T) ci;
    }

    private void prefillDefaults(BaseConfigurationItem ci) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors.values()) {
            if (propertyDescriptor.getDefaultValue() != null) {
                propertyDescriptor.set(ci, propertyDescriptor.getDefaultValue());
            }
        }
    }

    @Override
    public <T extends ConfigurationItem> T newInstance(String id) {
        T t = newInstance();
        t.setId(id);
        return t;
    }

    public void setDeployableType(Type deployableType) {
        this.deployableType = deployableType;
    }

    public void setContainerType(Type containerType) {
        this.containerType = containerType;
    }

    @Override
    public Type getDeployableType() {
        return deployableType;
    }

    @Override
    public Type getContainerType() {
        return containerType;
    }

    @Override
    public List<ValidationMessage> validate(ConfigurationItem ci) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public boolean isInspectable() {
        return inspectable;
    }

    public void setInspectable() {
        this.inspectable = true;
    }
}
