package com.xebialabs.deployit.booter.remote.xml;

import java.util.ArrayList;
import java.util.List;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.booter.remote.execution.RemoteTaskState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.xltype.serialization.xstream.AbstractTaskConverter;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;

public class TaskConverter extends AbstractTaskConverter {
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteTaskState t = new RemoteTaskState();
        t.setId(reader.getAttribute("id"));
        t.setNrSteps(Integer.valueOf(reader.getAttribute("totalSteps")));
        t.setFailureCount(Integer.valueOf(reader.getAttribute("failures")));
        t.setState(TaskExecutionState.valueOf(reader.getAttribute("state")));
        t.setOwner(reader.getAttribute("owner"));

        List<Integer> currentSteps = new ArrayList<Integer>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                t.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                t.setStartDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                t.setCompletionDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("scheduledDate".equals(reader.getNodeName())) {
                t.setScheduledDate(new DateTimeAdapter().fromString(reader.getValue()));
            } else if ("currentSteps".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    currentSteps.add(Integer.valueOf(reader.getValue()));
                    reader.moveUp();
                }
            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    t.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            } else if ("steps".equals(reader.getNodeName())) {
                List<StepState> stepStates = Converters.readList(t, StepState.class, reader, context);
                t.setSteps(stepStates);
            }
            reader.moveUp();
        }
        t.setCurrentStepNrs(currentSteps);
        return t;
    }
}
