package com.xebialabs.deployit.booter.remote.resteasy;

import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;

import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.StringReader;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;

@Provider
public class InternalServerErrorClientResponseInterceptor implements ClientErrorInterceptor {

    @Override
    public void handle(ClientResponse<?> clientResponse) throws DeployitClientException {
        logger.info("Handling Error Response, status code: {}", clientResponse.getStatus());
        tryDeployitException(clientResponse);
        tryUnhandledException(clientResponse);
    }

    private void tryUnhandledException(final ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey("X-Unhandled-Exception")) {
            logger.debug("Found unhandled header");
            final String exceptionType = clientResponse.getHeaders().getFirst("X-Exception-Type");
            String path = clientResponse.getHeaders().getFirst("X-Path");
            try {
                String messages = tryToReadEntity(clientResponse);
                throw new RuntimeException(String.format("%s [%s]: %s", exceptionType, path, messages != null ? messages : ""));
            } finally {
                ((BaseClientResponse) clientResponse).releaseConnection();
            }
        }
    }

    private void tryDeployitException(final ClientResponse<?> clientResponse) {
        if (clientResponse.getHeaders().containsKey("X-Deployit-Exception")) {
            logger.debug("Found XL Deploy header");
            try {
                final String exceptionType = clientResponse.getHeaders().getFirst("X-Exception-Type");
                String path = clientResponse.getHeaders().getFirst("X-Path");
                String messages = tryToReadEntity(clientResponse);
                if (clientResponse.getHeaders().containsKey("X-Entity") && messages != null) {
                    XStream xStream = XStreamReaderWriter.getConfiguredXStream();
                    final DataHolder dataHolder = new MapBackedDataHolder();
                    dataHolder.put("BOOTER_CONFIG", clientResponse.getHeaders().getFirst("BOOTER_CONFIG"));
                    Object o = xStream.unmarshal(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER.createReader(new StringReader(messages)), null, dataHolder);
                    throw new DeployitClientException(o, clientResponse.getStatus());
                }
                throw new DeployitClientException(String.format("%s [%s]: %s", exceptionType, path, messages != null ? messages : ""), clientResponse.getStatus());
            } finally {
                ((BaseClientResponse) clientResponse).releaseConnection();
            }
        }
    }

    private String tryToReadEntity(ClientResponse<?> clientResponse) {
        String messages = null;
        try {
            messages = clientResponse.getEntity(String.class);
        } catch (ReaderException re) {
            // Catch ignore...
        }
        return messages;
    }

    private static final Logger logger = LoggerFactory.getLogger(InternalServerErrorClientResponseInterceptor.class);
}
