/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.execution;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import org.joda.time.DateTime;

import java.util.*;

public class RemoteTaskState implements TaskWithSteps {
    private TaskExecutionState state;
    private String id;
    private String description;
    private DateTime startDate;
    private DateTime completionDate;
    private int nrSteps;
    private List<Integer> currentStepNrs = new ArrayList<>();
    private Map<String, String> metadata = new HashMap<>();
    private int failureCount;
    private List<StepState> steps = new ArrayList<>();
    private String owner;
    private DateTime scheduledDate;
    private List<TaskPackageDependency> packageDependencies = new ArrayList<>();

    @Override
    public TaskExecutionState getState() {
        return state;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public DateTime getScheduledDate() {
        return scheduledDate;
    }

    @Override
    public DateTime getStartDate() {
        return startDate;
    }

    @Override
    public DateTime getCompletionDate() {
        return completionDate;
    }

    @Override
    public int getNrSteps() {
        return nrSteps;
    }

    /**
     * @deprecated Use {@link #getCurrentStepNrs()} instead.
     */
    @Override
    @Deprecated
    public int getCurrentStepNr() {
        return currentStepNrs.size() > 0 ? currentStepNrs.get(0) : 0;
    }

    @Override
    public List<Integer> getCurrentStepNrs() {
        return currentStepNrs;
    }

    @Override
    public Map<String, String> getMetadata() {
        return metadata;
    }

    @Override
    public int getFailureCount() {
        return failureCount;
    }

    @Override
    public String getOwner() {
        return owner;
    }

    @Override
    public List<StepState> getSteps() {
        return steps;
    }

    @Override
    public StepState getStep(int stepNr) {
        if (stepNr <= 0 || stepNr > steps.size()) {
            throw new IllegalArgumentException(String.format("Not a valid step number [%s]", stepNr));
        }
        return steps.get(stepNr - 1);
    }

    public void setState(TaskExecutionState state) {
        this.state = state;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = startDate;
    }

    public void setCompletionDate(DateTime completionDate) {
        this.completionDate = completionDate;
    }

    public void setScheduledDate(DateTime scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public void setNrSteps(int nrSteps) {
        this.nrSteps = nrSteps;
    }

    /**
     * @deprecated Use {@link #setCurrentStepNrs(List)} instead.
     */
    @Deprecated
    public void setCurrentStepNr(int currentStepNr) {
        setCurrentStepNrs(Collections.singletonList(currentStepNr));
    }

    public void setCurrentStepNrs(List<Integer> currentStepNrs) {
        this.currentStepNrs = new ArrayList<>(currentStepNrs);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public void setSteps(List<StepState> steps) {
        this.steps = steps;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public String toString() {
        return id;
    }

    @Override
    public List<TaskPackageDependency> getPackageDependencies() {
        return packageDependencies;
    }
}
