/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote;

import java.io.Serializable;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;

public class RemoteMethodDescriptor implements MethodDescriptor, Serializable {
    private String name;
    private String description;
    private String fqn;
    private String label;
    private Map<String, String> attributes;
    private Type parameterType;

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return label;
    }

    public void setLabel(final String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Map<String, String> getAttributes() {
        return attributes;
    }

    @Override
    public Type getParameterObjectType() {
        return parameterType;
    }

    public void setParameterObjectType(Type parameterType) {
        this.parameterType = parameterType;
    }

    @Override
    public <T> T invoke(final ConfigurationItem item, final Parameters params) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void setAttributes(final Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getFqn() {
        return fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Override
    public <T> T invoke(ConfigurationItem item) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }
}
