/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.booter.remote.DeployitCommunicator;
import com.xebialabs.deployit.booter.remote.RemoteDescriptorRegistry;
import com.xebialabs.deployit.booter.remote.resteasy.InternalServerErrorClientResponseInterceptor;
import com.xebialabs.xltype.serialization.xstream.LocalDateStringConverter;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.MethodAnnotationScanner;
import nl.javadude.scannit.scanner.SubTypeScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteBooter {
    private static final ReentrantLock M = new ReentrantLock();
    private static final AtomicBoolean BOOTED = new AtomicBoolean(false);
    private static final Map<String, DeployitCommunicator> COMMUNICATORS = new ConcurrentHashMap<String, DeployitCommunicator>();
    private static ResteasyDeployment resteasyDeployment;
    private static final Logger logger;

    public static DeployitCommunicator boot(BooterConfig config) {
        if (!BOOTED.get()) {
            M.lock();
            try {
                RemoteBooter.doBoot(config);
            }
            finally {
                M.unlock();
            }
        }
        return RemoteBooter.getCommunicator(config);
    }

    private static void doBoot(BooterConfig config) {
        if (!BOOTED.get()) {
            Scannit.boot((Configuration)Configuration.config().scan("com.xebialabs").scan("ext.deployit").with(new AbstractScanner[]{new TypeAnnotationScanner(), new MethodAnnotationScanner(), new SubTypeScanner()}));
            RemoteBooter.bootResteasy();
            DeployitCommunicator communicator = new DeployitCommunicator(config);
            COMMUNICATORS.put(config.getKey(), communicator);
            RemoteDescriptorRegistry.boot(communicator);
            XStreamReaderWriter.registerConfigurationItemAliases();
            BOOTED.set(true);
        }
    }

    public static DeployitCommunicator getCommunicator(BooterConfig config) {
        if (!BOOTED.get()) {
            throw new IllegalStateException("Should first boot the RemoteBooter.");
        }
        if (!COMMUNICATORS.containsKey(config.getKey())) {
            M.lock();
            try {
                if (!COMMUNICATORS.containsKey(config.getKey())) {
                    DeployitCommunicator communicator = new DeployitCommunicator(config);
                    COMMUNICATORS.put(config.getKey(), communicator);
                    RemoteDescriptorRegistry.boot(communicator);
                }
            }
            finally {
                M.unlock();
            }
        }
        return COMMUNICATORS.get(config.getKey());
    }

    public static DeployitCommunicator getCommunicator(String key) {
        if (!COMMUNICATORS.containsKey(key)) {
            throw new IllegalStateException("The requested DeployitCommunicator has not been initialized.");
        }
        return COMMUNICATORS.get(key);
    }

    public static void shutdown() {
        M.lock();
        try {
            if (BOOTED.get()) {
                for (String configKey : new HashSet<String>(COMMUNICATORS.keySet())) {
                    COMMUNICATORS.get(configKey).shutdown();
                }
                resteasyDeployment.stop();
                BOOTED.set(false);
            }
        }
        finally {
            M.unlock();
        }
    }

    private static void bootResteasy() {
        resteasyDeployment = new ResteasyDeployment();
        resteasyDeployment.getProviderClasses().add(LocalDateStringConverter.class.getName());
        resteasyDeployment.getProviderClasses().add(InternalServerErrorClientResponseInterceptor.class.getName());
        resteasyDeployment.setAddCharset(true);
        resteasyDeployment.start();
    }

    static void remove(BooterConfig config) {
        COMMUNICATORS.remove(config.getKey());
    }

    static {
        logger = LoggerFactory.getLogger(RemoteBooter.class);
    }
}

