/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.*;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

@SuppressWarnings("serial")
public class RemotePropertyDescriptor implements PropertyDescriptor, Serializable {
    static final Field syntheticField = initSyntheticField();

    private static Field initSyntheticField() {
        try {
            Field f = BaseConfigurationItem.class.getDeclaredField(BaseConfigurationItem.SYNTHETIC_PROPERTIES_FIELD);
            f.setAccessible(true);
            return f;
        } catch (NoSuchFieldException e) {
            throw new IllegalStateException("Could not find the Synthetic property field.");
        }
    }

    private String name;
    private String label;
    private PropertyKind kind;
    private List<String> enumValues = new ArrayList<String>();
    private Type referencedType;
    private String description;
    private String category;
    private String defaultValue;
    private boolean password;
    private boolean required;
    private boolean containment = false;
    private boolean isTransient;
    private Property.Size size;
    private boolean inspectionProperty;
    private boolean requiredInspection;
    private String fqn;
    private String candidateValuesFilter;
    private boolean hidden = false;

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isAsContainment() {
        return containment;
    }

    public void setAsContainment() {
        containment = true;
    }

    @Override
    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isPassword() {
        return password;
    }

    public void setPassword() {
        password = true;
    }

    @Override
    public boolean isRequired() {
        return required;
    }

    public void setRequired() {
        required = true;
    }

    @Override
    public Property.Size getSize() {
        return size;
    }

    public void setSize(Property.Size size) {
        this.size = size;
    }

    @Override
    public PropertyKind getKind() {
        return kind;
    }

    public void setKind(PropertyKind kind) {
        this.kind = kind;
    }

    @Override
    public List<String> getEnumValues() {
        return enumValues;
    }

    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    @Override
    public Type getReferencedType() {
        return referencedType;
    }

    public void setReferencedType(Type referencedType) {
        this.referencedType = referencedType;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    public void setTransient() {
        isTransient = true;
    }

    @Override
    public String getCandidateValuesFilter() {
        return candidateValuesFilter;
    }

    public void setCandidateValuesFilter(String candidateValuesFilter) {
        this.candidateValuesFilter = candidateValuesFilter;
    }

    @Override
    public Object get(ConfigurationItem item) {
        try {
            @SuppressWarnings("unchecked")
            Map<String, Object> props = (Map<String, Object>) syntheticField.get(item);
            return props.get(name);
        } catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access Synthetic properties...");
        }
    }

    @Override
    public void set(ConfigurationItem item, Object value) {
        // TODO! Conversion
        try {
            @SuppressWarnings("unchecked")
            Map<String, Object> props = (Map<String, Object>) syntheticField.get(item);
            props.put(name, PropertyConverter.convertValue(kind, value));
        } catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access Synthetic properties...");
        }
    }

    @Override
    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        // TODO implement
        return false;  //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public String getFqn() {
        return fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Override
    public boolean isRequiredForInspection() {
        return requiredInspection;
    }

    public void setRequiredInspection() {
        this.requiredInspection = true;
    }

    @Override
    public boolean isHidden() {
        return hidden;
    }

    public void setHidden() {
        this.hidden = true;
    }

    @Override
    public boolean isInspectionProperty() {
        return inspectionProperty;
    }

    public void setInspectionProperty() {
        this.inspectionProperty = true;
    }

    @Override
    public Set<String> getAliases() {
        return new HashSet<>();
    }

    public boolean isDeployedSpecific() {
        return false;
    }
}
