/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = SerializableTask.class, tagName = "task")
public class TaskConverterSelector implements Converter {

    @Override
    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        throw new UnsupportedOperationException("Core will not deserialize tasks");
    }

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        if(reader.getAttribute("currentStep") != null){
            return new TaskConverter().unmarshal(reader, context);
        } else {
            return new TaskWithBlockConverter().unmarshal(reader, context);
        }
    }

    @Override
    public boolean canConvert(final Class type) {
        return SerializableTask.class.isAssignableFrom(type);

    }
}
