/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.booter.remote.execution.RemoteStepState;
import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.util.DateUtil;
import com.xebialabs.xltype.serialization.xstream.AbstractStepConverter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = StepState.class, tagName = "step")
public class StepConverter extends AbstractStepConverter {
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        RemoteStepState s = new RemoteStepState();
        if(reader.getAttribute("failures") != null){
            s.setFailureCount(Integer.valueOf(reader.getAttribute("failures")));
        }
        if(reader.getAttribute("skippable") != null){
            s.setSkippable(Boolean.valueOf(reader.getAttribute("skippable")));
        }
        s.setState(StepExecutionState.valueOf(reader.getAttribute("state")));

        String attrDescription = reader.getAttribute("description");
        if (attrDescription != null) {
            s.setDescription(attrDescription);
        }

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("description".equals(reader.getNodeName())) {
                s.setDescription(reader.getValue());
            } else if ("startDate".equals(reader.getNodeName())) {
                s.setStartDate(DateUtil.fromString(reader.getValue()));
            } else if ("completionDate".equals(reader.getNodeName())) {
                s.setCompletionDate(DateUtil.fromString(reader.getValue()));
            } else if ("log".equals(reader.getNodeName())) {
                s.setLog(reader.getValue());
            } else if ("metadata".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    s.getMetadata().put(reader.getNodeName(), reader.getValue());
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        return s;
    }
}
