/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.xebialabs.deployit.booter.remote.execution.RemoteStepBlockState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.xstream.Converters;

import java.util.List;

class RemoteStepBlockReader extends BlockReader {
    private UnmarshallingContext context;

    public RemoteStepBlockReader(HierarchicalStreamReader reader, UnmarshallingContext context) {
        super(reader);
        this.context = context;
    }

    public BlockState read() {
        RemoteStepBlockState block = new RemoteStepBlockState();

        setCommonPropertiesOn(block);

        block.setCurrentStep(Integer.parseInt(reader.getAttribute("current")));
        List<StepState> stepStates = Converters.readList(block, StepState.class, reader, context);

        block.setSteps(stepStates);

        return block;
    }
}
