package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.resteasy.DeployitEntityExtractorFactory;
import com.xebialabs.deployit.engine.api.*;

import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.booter.remote.HttpClientHolder.httpClient;
import static com.xebialabs.deployit.booter.remote.HttpClientHolder.httpContext;
import static org.jboss.resteasy.client.ProxyFactory.createUri;

public class Proxies {
    private static final Map<Class<?>, Object> registeredProxies = new HashMap<Class<?>, Object>();

    public static void init(BooterConfig config) {
        for (Class<?> clazz : allProxies()) {
            registerProxy(config.getUrl(), clazz);
        }
    }

    public static void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor(httpClient(), httpContext());
        registeredProxies.put(clazz, ProxyFactory.create(clazz, createUri(url), clientExecutor, ResteasyProviderFactory.getInstance(), new DeployitEntityExtractorFactory()));
    }

    @SuppressWarnings("unchecked")
    private static Iterable<Class<?>> allProxies() {
        return newArrayList(
                ServerService.class, MetadataService.class, RepositoryService.class,
                ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class,
                PermissionService.class, RoleService.class, TaskService.class, UserService.class);
    }

    @SuppressWarnings("unchecked")
    public static <T> T getProxyInstance(Class<T> clazz) {
        return (T) registeredProxies.get(clazz);
    }

    public static ServerService getServerService() {
        return getProxyInstance(ServerService.class);
    }

    public static MetadataService getMetadataService() {
        return getProxyInstance(MetadataService.class);
    }

    public static RepositoryService getRepositoryService() {
        return getProxyInstance(RepositoryService.class);
    }

    public static ControlService getControlService() {
        return getProxyInstance(ControlService.class);
    }

    public static DeploymentService getDeploymentService() {
        return getProxyInstance(DeploymentService.class);
    }

    public static InspectionService getInspectionService() {
        return getProxyInstance(InspectionService.class);
    }

    public static PackageService getPackageService() {
        return getProxyInstance(PackageService.class);
    }

    public static PermissionService getPermissionService() {
        return getProxyInstance(PermissionService.class);
    }

    public static RoleService getRoleService() {
        return getProxyInstance(RoleService.class);
    }

    public static TaskService getTaskService() {
        return getProxyInstance(TaskService.class);
    }

    public static UserService getUserService() {
        return getProxyInstance(UserService.class);
    }

    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);
}
