package com.xebialabs.deployit.booter.remote;

import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.booter.remote.service.StreamingImportingService;
import com.xebialabs.deployit.booter.remote.resteasy.DeployitEntityExtractorFactory;
import com.xebialabs.deployit.engine.api.*;

import static com.google.common.collect.Lists.newArrayList;
import static org.jboss.resteasy.client.ProxyFactory.createUri;

public class Proxies {
    private final Map<Class<?>, Object> registeredProxies = new HashMap<Class<?>, Object>();
    private final DeployitCommunicator communicator;

    public Proxies(DeployitCommunicator communicator) {
        this.communicator = communicator;
        init(communicator.getConfig());
    }

    private void init(BooterConfig config) {
        for (Class<?> clazz : allProxies()) {
            registerProxy(config.getUrl(), clazz);
        }
    }

    public static Logger getLogger() {
        return logger;
    }

    public void registerProxy(String url, Class<?> clazz) {
        logger.debug("Registering Proxy: {}", clazz);
        ApacheHttpClient4Executor clientExecutor = new ApacheHttpClient4Executor(communicator.httpClient(), communicator.httpContext());
        registeredProxies.put(clazz, ProxyFactory.create(clazz, createUri(url), clientExecutor, ResteasyProviderFactory.getInstance(), new DeployitEntityExtractorFactory()));
    }

    @SuppressWarnings("unchecked")
    private static Iterable<Class<?>> allProxies() {
        return newArrayList(
                ServerService.class, MetadataService.class, RepositoryService.class,
                ControlService.class, DeploymentService.class, InspectionService.class, PackageService.class,
                PermissionService.class, RoleService.class, TaskService.class, UserService.class);
    }

    @SuppressWarnings("unchecked")
    public <T> T getProxyInstance(Class<T> clazz) {
        return (T) registeredProxies.get(clazz);
    }

    public ServerService getServerService() {
        return getProxyInstance(ServerService.class);
    }

    public MetadataService getMetadataService() {
        return getProxyInstance(MetadataService.class);
    }

    public RepositoryService getRepositoryService() {
        return getProxyInstance(RepositoryService.class);
    }

    public ControlService getControlService() {
        return getProxyInstance(ControlService.class);
    }

    public DeploymentService getDeploymentService() {
        return getProxyInstance(DeploymentService.class);
    }

    public InspectionService getInspectionService() {
        return getProxyInstance(InspectionService.class);
    }

    public PackageService getPackageService() {
        return new StreamingImportingService(communicator, this);
    }

    public PermissionService getPermissionService() {
        return getProxyInstance(PermissionService.class);
    }

    public RoleService getRoleService() {
        return getProxyInstance(RoleService.class);
    }

    public TaskService getTaskService() {
        return getProxyInstance(TaskService.class);
    }

    public UserService getUserService() {
        return getProxyInstance(UserService.class);
    }

    private static final Logger logger = LoggerFactory.getLogger(Proxies.class);
}
