package com.xebialabs.deployit.engine.replacer;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

public class ScanningMap implements Map<String, String> {
    private Set<String> keys = newHashSet();
    @Override
    public int size() {
        return keys.size();
    }

    @Override
    public boolean isEmpty() {
        return keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        keys.add((String) key);
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("containsValue");
    }

    @Override
    public String get(Object key) {
        keys.add((String) key);
        return (String) key;
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException("put");
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public Set<String> keySet() {
        return newHashSet(keys);
    }

    @Override
    public Collection<String> values() {
        return newHashSet(keys);
    }

    @Override
    public Set<Entry<String, String>> entrySet() {
        throw new UnsupportedOperationException("entrySet");
    }
}
