package com.xebialabs.deployit.engine.tasker;

import com.google.common.io.Closeables;

import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;

import javassist.util.proxy.ProxyObjectOutputStream;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

import static java.lang.String.format;

class TaskRecoveryTrigger implements ExecutionStateListener {

    private File recoveryDir;

    public TaskRecoveryTrigger(File recoveryDir) {
        this.recoveryDir = recoveryDir;
    }

    @Override
    public void stepStateChanged(StepExecutionStateEvent event) {
        TaskState task = event.task();
        writeRecovery(task);
    }

    private void writeRecovery(TaskState task) {
        String id = task.getId();
        ObjectOutputStream os = null;
        try {
            os = new ProxyObjectOutputStream(new FileOutputStream(getFile(id)));
            os.writeObject(task);
        } catch (IOException e) {
            logger.error(format("Could not write recovery file for [%s]", id), e);
        } finally {
            Closeables.closeQuietly(os);
        }
    }

    private File getFile(String id) {
        return new File(recoveryDir, id + ".task");
    }

    @Override
    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (event.currentState().isFinal()) {
            File file = getFile(event.task().getId());
            file.delete();
        } else {
            writeRecovery(event.task());
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(TaskRecoveryTrigger.class);
}
