package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.flow.Step;

import java.util.List;
import java.util.Map;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Maps.newHashMap;

public class TaskSpecification {
    private final String description;
    private final String owner;
    private final List<TaskStep> steps;
    private final Map<String, String> metadata = newHashMap();
    private final List<ExecutionStateListener> listeners = newArrayList();
    private TaskInspectionContext inspectionContext;

    public TaskSpecification(String description, String owner, List<TaskStep> steps) {
        this.description = description;
        this.owner = owner;
        this.steps = steps;
    }

    public TaskSpecification(String description, String owner, List<TaskStep> steps, TaskInspectionContext inspectionContext) {
        this.description = description;
        this.owner = owner;
        this.steps = steps;
        this.inspectionContext = inspectionContext;
    }

    public String getDescription() {
        return description;
    }

    public List<TaskStep> getSteps() {
        return steps;
    }

    public String getOwner() {
        return owner;
    }

    public Map<String, String> getMetadata() {
        return metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return inspectionContext;
    }
}
