/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.io.Closeables;
import com.google.common.util.concurrent.Monitor;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javassist.util.proxy.ProxyObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskRecoveryTrigger
implements ExecutionStateListener {
    private static final Timer t = new Timer("recovery-writer");
    private File recoveryDir;
    private transient AtomicReference<TaskState> taskReference = new AtomicReference();
    private transient Monitor M = new Monitor();
    private static final Logger logger = LoggerFactory.getLogger(TaskRecoveryTrigger.class);

    public TaskRecoveryTrigger(File recoveryDir) {
        this.recoveryDir = recoveryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stepStateChanged(StepExecutionStateEvent event) {
        this.M.enter();
        try {
            this.startWritingTimer(event.task());
        }
        finally {
            this.M.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStateChanged(TaskExecutionStateEvent event) {
        this.M.enter();
        try {
            if (!event.currentState().isFinal()) {
                this.startWritingTimer((TaskState)event.task());
            } else {
                this.taskReference.set(null);
                this.getFile(event.task().getId()).delete();
            }
        }
        finally {
            this.M.leave();
        }
    }

    private void startWritingTimer(TaskState task) {
        if (this.taskReference.compareAndSet(null, task)) {
            t.schedule((TimerTask)new RecoveryTimerTask(), 1000L);
            logger.debug("Scheduled Recovery writer for [{}] for 1 second from now", (Object)task.getId());
        }
    }

    private File getFile(String id) {
        return new File(this.recoveryDir, id + ".task");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.M = new Monitor();
        this.taskReference = new AtomicReference();
    }

    private class RecoveryTimerTask
    extends TimerTask {
        private RecoveryTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskRecoveryTrigger.this.M.enter();
            try {
                if (TaskRecoveryTrigger.this.taskReference.get() != null) {
                    logger.debug("Writing recovery file for: [{}]", TaskRecoveryTrigger.this.taskReference.get());
                    this.writeRecovery((TaskState)TaskRecoveryTrigger.this.taskReference.get());
                }
            }
            finally {
                TaskRecoveryTrigger.this.taskReference.set(null);
                TaskRecoveryTrigger.this.M.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeRecovery(TaskState task) {
            String id = task.getId();
            ProxyObjectOutputStream os = null;
            try {
                os = new ProxyObjectOutputStream((OutputStream)new FileOutputStream(TaskRecoveryTrigger.this.getFile(id)));
                os.writeObject(task);
            }
            catch (IOException e) {
                try {
                    logger.error(String.format("Could not write recovery file for [%s]", id), (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(os);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)os);
            }
            Closeables.closeQuietly((Closeable)os);
        }
    }
}

