/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.tasker.EventBusAdapter;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.services.Repository;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import nl.javadude.t2bus.EventHandlerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskExecutionContext
implements Serializable {
    private transient EventBusAdapter bus;
    private transient Repository repository;
    private Map<String, Object> attributes = Maps.newHashMap();
    private TaskInspectionContext inspectionContext;
    private static final Logger logger = LoggerFactory.getLogger(TaskExecutionContext.class);

    TaskExecutionContext(List<ExecutionStateListener> listeners, TaskInspectionContext context) {
        for (ExecutionStateListener listener : listeners) {
            this.attributes.put(listener.getClass().getName(), listener);
        }
        this.inspectionContext = context;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        EventBusAdapter.tryRegister(value, this.bus);
        this.attributes.put(name, value);
    }

    public void unsetAttribute(String name) {
        EventBusAdapter.tryUnregister(this.attributes.get(name), this.bus);
        this.attributes.remove(name);
    }

    public InspectionContext getInspectionContext() {
        Preconditions.checkState((this.inspectionContext != null ? 1 : 0) != 0, (Object)"InspectionContext is not set, are you currently running an Inspection?");
        return this.inspectionContext;
    }

    public Repository getRepository() {
        return this.repository;
    }

    void init(EventBusAdapter bus, Repository repository) {
        this.bus = bus;
        this.repository = repository;
        for (Object o : this.attributes.values()) {
            EventBusAdapter.tryRegister(o, this.bus);
        }
    }

    void publish(TaskExecutionStateEvent e, EventHandlerStrategy handler) {
        Preconditions.checkState((this.bus != null ? 1 : 0) != 0, (Object)"No EventBus is set on the context");
        this.bus.post(e, handler);
    }

    void publish(StepExecutionStateEvent e, EventHandlerStrategy handler) {
        Preconditions.checkState((this.bus != null ? 1 : 0) != 0, (Object)"No EventBus is set on the context");
        this.bus.post(e, handler);
    }

    void publish(TaskExecutionStateEvent e) {
        Preconditions.checkState((this.bus != null ? 1 : 0) != 0, (Object)"No EventBus is set on the context");
        this.bus.post(e);
    }

    void publish(StepExecutionStateEvent e) {
        Preconditions.checkState((this.bus != null ? 1 : 0) != 0, (Object)"No EventBus is set on the context");
        this.bus.post(e);
    }

    Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

