package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;

final class StepEvent implements StepExecutionStateEvent {
    private StepExecutionState previousState;
    private StepExecutionState currentState;
    private TaskState task;
    private StepState step;


    StepEvent(StepExecutionState previousState, StepExecutionState currentState, TaskState task, StepState step) {
        this.previousState = previousState;
        this.currentState = currentState;
        this.task = task;
        this.step = step;
    }

    @Override
    public StepExecutionState previousState() {
        return previousState;
    }

    @Override
    public StepExecutionState currentState() {
        return currentState;
    }

    @Override
    public StepState step() {
        return step;
    }

    @Override
    public TaskState task() {
        return task;
    }

    @Override
    public String toString() {
        return String.format("StepEvent[%s: %s -> %s]", step.getDescription(), previousState, currentState);
    }

}
