/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.deployment.planner.DeltaSpecificationBuilder;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.test.deployment.DeployitTester;
import com.xebialabs.deployit.test.support.ItestTopology;
import com.xebialabs.deployit.test.support.TestExecutionContext;
import com.xebialabs.deployit.test.support.TestUtils;
import com.xebialabs.deployit.test.support.junit.Parameterized;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class DeployedItestBase {
    private static final Logger logger = LoggerFactory.getLogger(DeployedItestBase.class);
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private static final String DEPLOYED_ITEST_DIR = "deployed-test-scripts";
    private File deployedPropertiesFile;
    protected ItestTopology topology;
    protected Container container;
    private static DeployitTester tester;
    private List<Type> additionalTypesToDiscover = Lists.newArrayList();
    private Map<String, Deployed> deployedDependencies = Maps.newHashMap();
    private Set<PropertyDescriptor> requiredForInspection = Sets.newHashSet();
    private DeployMode deployMode = DeployMode.CREATE;
    private static TestExecutionContext context;

    public DeployedItestBase(String description, File deployedPropertiesFile, ItestTopology topology, Container container) {
        this.deployedPropertiesFile = deployedPropertiesFile;
        this.topology = topology;
        this.container = container;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getTargets() throws URISyntaxException, IOException, JDOMException {
        ArrayList<Object[]> constructorArgsList = new ArrayList<Object[]>();
        Map<String, ItestTopology> topologies = ItestTopology.load();
        for (File deployedItestFile : DeployedItestBase.getDeployedItestFiles()) {
            String desc = "Test " + deployedItestFile.getName() + " on ";
            for (ItestTopology topology : topologies.values()) {
                if (!ItestTopology.isItestEnabled(topology.getId(), topology.isEnabledByDefault())) continue;
                for (Container container : topology.getTargets()) {
                    constructorArgsList.add(new Object[]{desc + container, deployedItestFile, topology, container});
                }
            }
        }
        return constructorArgsList;
    }

    @Before
    public void clearAdditionalTypesToDiscoverAndRequiredDeployeds() {
        this.deployedDependencies.clear();
        this.additionalTypesToDiscover.clear();
    }

    @After
    public void clearInspectionContext() {
        context.clearInspectionContext();
    }

    @BeforeClass
    public static void setup() {
        tester = new DeployitTester();
        context = new TestExecutionContext(DeployedItestBase.class);
    }

    @AfterClass
    public static void tearDown() {
        context.destroy();
    }

    private static Iterable<File> getDeployedItestFiles() throws URISyntaxException, IOException {
        File deployedItestDir = DeployedItestBase.getDeployedItestDir();
        final List<String> enabledItests = DeployedItestBase.getEnabledItests();
        return Iterables.filter(Arrays.asList(deployedItestDir.listFiles()), (Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                String name = input.getName();
                return name.endsWith(".xml") && (enabledItests.isEmpty() || enabledItests.contains(name));
            }
        });
    }

    private static File getDeployedItestDir() throws URISyntaxException {
        URL deployedItestDirUrl = Thread.currentThread().getContextClassLoader().getResource(DEPLOYED_ITEST_DIR);
        Preconditions.checkNotNull((Object)deployedItestDirUrl);
        return new File(deployedItestDirUrl.toURI());
    }

    private static List<String> getEnabledItests() throws URISyntaxException, IOException {
        File deployedItestDir = DeployedItestBase.getDeployedItestDir();
        File enabledItestsFile = new File(deployedItestDir, "enabled-itests");
        ArrayList enabledItests = Lists.newArrayList();
        if (enabledItestsFile.exists()) {
            List tests = Files.readLines((File)enabledItestsFile, (Charset)Charset.defaultCharset());
            enabledItests.addAll(tests);
        }
        return enabledItests;
    }

    @Test
    public void shouldCreateAndDestroyDeployed() throws Exception {
        List<Deployed> deployeds = this.readDeployeds();
        Assume.assumeTrue((deployeds.size() > 0 ? 1 : 0) != 0);
        ArrayList deployedsWithDependencies = Lists.newArrayList(this.deployedDependencies.values());
        deployedsWithDependencies.addAll(deployeds);
        this.assignDeployedsToContainer(deployedsWithDependencies);
        if (this.shouldCheckDeployedsDoNotExistBeforeCreating()) {
            this.assertDeployedsDoNotExist(deployedsWithDependencies);
            context.clearInspectionContext();
        }
        if (this.shouldCreateDeployed()) {
            this.createDeployeds(deployedsWithDependencies);
            context.clearInspectionContext();
        }
        if (this.shouldCheckDeployedsCreatedCorrectly()) {
            this.assertDeployedsWereCreatedCorrectly(deployedsWithDependencies);
            context.clearInspectionContext();
        }
        if (this.shouldDestroyDeployeds()) {
            this.destroyDeployeds(deployedsWithDependencies);
            context.clearInspectionContext();
        }
        if (this.shouldCheckDeployedsDoNotExistAfterDelete()) {
            this.assertDeployedsDoNotExist(deployedsWithDependencies);
            context.clearInspectionContext();
        }
    }

    protected void setDeployMode(String deployModeAttribute) {
        if (deployModeAttribute == null) {
            return;
        }
        try {
            this.deployMode = DeployMode.valueOf(deployModeAttribute.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unsupported deployMode value '%s' on itest tag expected [%s]", deployModeAttribute, Joiner.on((String)"|").join((Iterable)Lists.newArrayList((Object[])DeployMode.values()))));
        }
    }

    protected DeployMode getDeployMode() {
        return this.deployMode;
    }

    private List<Deployed> readDeployeds() throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        Document deployedProperties = sb.build(this.deployedPropertiesFile);
        HashMap deployeds = Maps.newHashMap();
        Element rootElement = deployedProperties.getRootElement();
        List deployedGroupElements = rootElement.getChildren("deployeds");
        this.setDeployMode(rootElement.getAttributeValue("deployMode"));
        for (Element deployedGroupElement : deployedGroupElements) {
            String additionalTypes = deployedGroupElement.getAttributeValue("additionalTypesToDiscover");
            if (Strings.isNotBlank((String)additionalTypes)) {
                for (String t : additionalTypes.split(",")) {
                    this.additionalTypesToDiscover.add(Type.valueOf((String)t.trim()));
                }
            }
            String target = deployedGroupElement.getAttributeValue("target");
            String alwaysDeployAttrVal = deployedGroupElement.getAttributeValue("alwaysDeployToTarget");
            boolean alwaysDeployToTarget = alwaysDeployAttrVal != null && alwaysDeployAttrVal.equals("true");
            List deployedElements = deployedGroupElement.getChildren();
            for (Element each : deployedElements) {
                this.convertDeployedElementToDeployed(each, target, alwaysDeployToTarget, deployeds);
            }
        }
        return Lists.newArrayList(deployeds.values());
    }

    private void convertDeployedElementToDeployed(Element deployedElement, String target, boolean alwaysDeployToTarget, Map<String, Deployed> deployeds) throws IOException {
        String name;
        Descriptor d = DescriptorRegistry.getDescriptor((String)deployedElement.getName());
        Preconditions.checkArgument((boolean)d.isAssignableTo(Deployed.class), (String)"Type [%s] is not assignable to udm.Deployed", (Object[])new Object[]{d.getType()});
        Deployed item = (Deployed)d.newInstance();
        if (item instanceof Artifact) {
            Element fileNameElm = deployedElement.getChild("fileName");
            Preconditions.checkArgument((fileNameElm != null ? 1 : 0) != 0, (String)"Type [%s] is an artifact and must specify fileName that can be resolved from the classpath", (Object[])new Object[]{d.getType()});
            File artifact = this.folder.newFile(OverthereUtils.getName((String)fileNameElm.getValue()));
            URL aURL = this.getClass().getClassLoader().getResource(fileNameElm.getValue());
            Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)aURL), (File)artifact);
            ((Artifact)item).setFile(LocalFile.valueOf((File)artifact));
        }
        if ((name = deployedElement.getAttributeValue("name")) == null) {
            name = (String)Preconditions.checkNotNull((Object)deployedElement.getAttributeValue("id"), (String)"Element [%s] has no [name] attribute", (Object[])new Object[]{deployedElement.getName()});
            logger.warn("Using deprecated 'id' in [{}], instead of 'name' for element [{}].", (Object)this.deployedPropertiesFile, (Object)deployedElement.getName());
        }
        item.setId(name);
        block6: for (Element p : deployedElement.getChildren()) {
            if (p.getName().equals("fileName")) continue;
            PropertyDescriptor pd = (PropertyDescriptor)Preconditions.checkNotNull((Object)d.getPropertyDescriptor(p.getName()), (String)"Property [%s.%s] does not exist", (Object[])new Object[]{d.getType(), p.getName()});
            if (p.getAttributeValue("inspectionProperty") != null && p.getAttributeValue("inspectionProperty").equals("true")) {
                this.requiredForInspection.add(pd);
            }
            switch (pd.getKind()) {
                case CI: {
                    pd.set((ConfigurationItem)item, (Object)this.resolveCiReference(p, pd, item, deployeds));
                    continue block6;
                }
                case MAP_STRING_STRING: {
                    HashMap map = Maps.newHashMap();
                    for (Element e : p.getChildren("entry")) {
                        map.put(Preconditions.checkNotNull((Object)e.getAttributeValue("key")), Preconditions.checkNotNull((Object)e.getValue()));
                    }
                    pd.set((ConfigurationItem)item, (Object)map);
                    continue block6;
                }
                case SET_OF_STRING: {
                    HashSet setOfString = Sets.newHashSet();
                    for (Element v : p.getChildren("value")) {
                        setOfString.add(v.getValue());
                    }
                    pd.set((ConfigurationItem)item, (Object)setOfString);
                    continue block6;
                }
                case SET_OF_CI: {
                    HashSet setOfCi = Sets.newHashSet();
                    for (Element v : p.getChildren("value")) {
                        setOfCi.add(this.resolveCiReference(v, pd, item, deployeds));
                    }
                    pd.set((ConfigurationItem)item, (Object)setOfCi);
                    continue block6;
                }
            }
            pd.set((ConfigurationItem)item, (Object)p.getValue());
        }
        if (target != null) {
            Type containerScopeType = Type.valueOf((String)target);
            if (this.container.getType().instanceOf(containerScopeType)) {
                deployeds.put(item.getId(), item);
            } else if (alwaysDeployToTarget) {
                item.setContainer(this.topology.findFirstMatchingTarget(containerScopeType));
                this.deployedDependencies.put(item.getId(), item);
            }
        } else {
            deployeds.put(item.getId(), item);
        }
    }

    private ConfigurationItem resolveCiReference(Element p, PropertyDescriptor pd, Deployed item, Map<String, Deployed> deployeds) {
        String ciRefId = p.getValue().trim();
        if (deployeds.containsKey(ciRefId)) {
            return (ConfigurationItem)deployeds.get(ciRefId);
        }
        if (this.deployedDependencies.containsKey(ciRefId)) {
            return (ConfigurationItem)this.deployedDependencies.get(ciRefId);
        }
        ciRefId = this.topology.replacePlaceholders(ciRefId);
        ConfigurationItem ciRef = this.topology.getItems().get(ciRefId);
        if (ciRef == null) {
            ciRef = DescriptorRegistry.getDescriptor((Type)pd.getReferencedType()).newInstance();
            ciRef.setId(ciRefId);
        }
        return ciRef;
    }

    private void assignDeployedsToContainer(List<Deployed> deployeds) {
        for (Deployed deployed : deployeds) {
            if (deployed.getContainer() == null) {
                deployed.setContainer(this.container);
            }
            deployed.setId(deployed.getContainer().getId() + "/" + deployed.getId());
        }
    }

    private void createDeployeds(List<Deployed> deployeds) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().initial(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), TestUtils.createEnvironment(this.container)));
        for (Deployed d : deployeds) {
            List validationErrors = DescriptorRegistry.getDescriptor((Type)d.getType()).validate((ConfigurationItem)d);
            if (validationErrors.isEmpty()) {
                builder.create(d);
                continue;
            }
            Assert.fail((String)("Deployed has validation errors: " + validationErrors));
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = tester.executePlan(resolvedPlan, context);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    private void destroyDeployeds(List<Deployed> deployeds) {
        DeltaSpecificationBuilder builder = new DeltaSpecificationBuilder().initial(TestUtils.createDeployedApplication(TestUtils.createDeploymentPackage("1.0", new Deployable[0]), TestUtils.createEnvironment(this.container)));
        for (Deployed d : deployeds) {
            builder.destroy(d);
        }
        DeltaSpecification spec = builder.build();
        List<Step> resolvedPlan = tester.resolvePlan(spec);
        StepExitCode result = tester.executePlan(resolvedPlan, context);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)StepExitCode.SUCCESS));
    }

    private void assertDeployedsDoNotExist(List<Deployed> deployeds) {
        block3: {
            try {
                List<Deployed> actualDeployeds = this.inspectDeployeds(deployeds);
                if (!actualDeployeds.isEmpty()) {
                    Assert.fail((String)String.format("Expected deployeds [%s] to not exist", Joiner.on((String)",").join(actualDeployeds)));
                }
            }
            catch (RuntimeException e) {
                if (e.getMessage().contains("Step failed:") || e.getMessage().contains("CliScriptException")) break block3;
                throw e;
            }
        }
    }

    private void assertDeployedsWereCreatedCorrectly(List<Deployed> expectedDeployeds) {
        List<Deployed> actualDeployeds = this.inspectDeployeds(expectedDeployeds);
        if (actualDeployeds.size() != expectedDeployeds.size()) {
            Assert.fail((String)String.format("Expected deployeds [%s] to exist, but only found [%s]", Joiner.on((String)",").join(expectedDeployeds), Joiner.on((String)",").join(actualDeployeds)));
        }
        for (Deployed expected : expectedDeployeds) {
            int i = actualDeployeds.indexOf(expected);
            Preconditions.checkArgument((i != -1 ? 1 : 0) != 0, (String)"Cannot find [%s] in list of existing deployeds", (Object[])new Object[]{expected});
            Deployed actual = actualDeployeds.get(i);
            DeployedItestBase.assertDeployedWasCreatedCorrectly(expected, actual);
        }
    }

    private static void assertDeployedWasCreatedCorrectly(Deployed expectedDeployed, Deployed actualDeployed) {
        Descriptor dd = DescriptorRegistry.getDescriptor((Type)expectedDeployed.getType());
        block5: for (PropertyDescriptor pd : dd.getPropertyDescriptors()) {
            if (pd.isHidden() || pd.isPassword() || pd.getKind() == PropertyKind.LIST_OF_CI) continue;
            switch (pd.getKind()) {
                case MAP_STRING_STRING: {
                    Map expectedMap = (Map)pd.get((ConfigurationItem)expectedDeployed);
                    Map inspectedMap = (Map)pd.get((ConfigurationItem)actualDeployed);
                    if (expectedMap == null) continue block5;
                    Assert.assertEquals((long)inspectedMap.size(), (long)expectedMap.size());
                    for (Map.Entry eachEntry : inspectedMap.entrySet()) {
                        Assert.assertThat(inspectedMap.get(eachEntry.getKey()), (Matcher)CoreMatchers.equalTo(expectedMap.get(eachEntry.getKey())));
                    }
                    continue block5;
                }
                case SET_OF_STRING: {
                    Integer diffInStringSets = Sets.symmetricDifference((Set)((Set)pd.get((ConfigurationItem)expectedDeployed)), (Set)((Set)pd.get((ConfigurationItem)actualDeployed))).size();
                    Assert.assertThat((String)("Expected " + pd.get((ConfigurationItem)expectedDeployed) + " but was " + pd.get((ConfigurationItem)actualDeployed)), (Object)diffInStringSets, (Matcher)CoreMatchers.equalTo((Object)0));
                    break;
                }
                case SET_OF_CI: {
                    HashSet set1 = Sets.newHashSet((Iterable)((Set)pd.get((ConfigurationItem)expectedDeployed)));
                    HashSet set2 = Sets.newHashSet((Iterable)((Set)pd.get((ConfigurationItem)actualDeployed)));
                    Integer diffInCiSets = Sets.symmetricDifference((Set)set1, (Set)set2).size();
                    Assert.assertThat((String)("Expected " + pd.get((ConfigurationItem)expectedDeployed) + " but was " + pd.get((ConfigurationItem)actualDeployed)), (Object)diffInCiSets, (Matcher)CoreMatchers.equalTo((Object)0));
                    break;
                }
                default: {
                    Object inspectedValue = pd.get((ConfigurationItem)actualDeployed);
                    Object expectedValue = pd.get((ConfigurationItem)expectedDeployed);
                    if (expectedValue == null) continue block5;
                    Assert.assertThat((Object)inspectedValue, (Matcher)CoreMatchers.equalTo((Object)expectedValue));
                }
            }
        }
    }

    private List<Deployed> inspectDeployeds(final List<Deployed> deployeds) {
        ArrayList typesToDiscover = Lists.newArrayList();
        typesToDiscover.addAll(this.additionalTypesToDiscover);
        typesToDiscover.addAll(Lists.transform(deployeds, (Function)new Function<Deployed, Type>(){

            public Type apply(Deployed input) {
                return input.getType();
            }
        }));
        List<Object> discovered = Lists.newArrayList();
        ConfigurationItem ciToPerformInspectionOn = this.getCiToPerformInspectionOn(typesToDiscover);
        if (ciToPerformInspectionOn != null) {
            discovered = tester.runInspectionTask(ciToPerformInspectionOn, context);
        } else {
            if (!this.additionalTypesToDiscover.isEmpty()) {
                throw new UnsupportedOperationException("The discovery of additional typess is not supported using old style discovery.");
            }
            for (Deployed deployed : this.cloneForInspection(deployeds)) {
                discovered.addAll(tester.runInspectionTask((ConfigurationItem)deployed, context));
            }
        }
        Iterable existingDeployeds = Iterables.filter((Iterable)discovered, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input instanceof Deployed && deployeds.contains(input);
            }
        });
        return Lists.newArrayList((Iterable)existingDeployeds);
    }

    public List<Deployed> cloneForInspection(List<Deployed> deployeds) {
        ArrayList clonedDeployeds = Lists.newArrayList();
        for (Deployed deployed : deployeds) {
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
            Deployed di = (Deployed)descriptor.newInstance();
            Iterable inspectProperties = Iterables.filter((Iterable)descriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

                public boolean apply(PropertyDescriptor input) {
                    return input.isInspectionProperty() || DeployedItestBase.this.requiredForInspection.contains(input);
                }
            });
            di.setId(deployed.getId());
            di.setDeployable(deployed.getDeployable());
            di.setContainer(deployed.getContainer());
            for (PropertyDescriptor inspectProperty : inspectProperties) {
                inspectProperty.set((ConfigurationItem)di, inspectProperty.get((ConfigurationItem)deployed));
            }
            clonedDeployeds.add(di);
        }
        return clonedDeployeds;
    }

    protected boolean shouldCheckDeployedsDoNotExistBeforeCreating() {
        return this.deployMode == DeployMode.CREATE;
    }

    protected boolean shouldCreateDeployed() {
        return true;
    }

    protected boolean shouldCheckDeployedsCreatedCorrectly() {
        return true;
    }

    protected boolean shouldDestroyDeployeds() {
        return this.deployMode == DeployMode.CREATE;
    }

    protected boolean shouldCheckDeployedsDoNotExistAfterDelete() {
        return this.deployMode == DeployMode.CREATE;
    }

    protected abstract ConfigurationItem getCiToPerformInspectionOn(List<Type> var1);

    static {
        LocalBooter.bootWithoutGlobalContext();
    }

    protected static enum DeployMode {
        CREATE,
        UPDATE_ONLY;

    }
}

