/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.test.deployment.DeltaSpecifications;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TestUtils {
    public static String readResource(String resource) throws IOException {
        return Resources.toString((URL)Resources.getResource((String)resource), (Charset)Charset.defaultCharset());
    }

    public static <T> T newInstance(String type) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)type);
        if (descriptor == null) {
            throw new RuntimeException("Cannot instantiate unknown type");
        }
        return (T)descriptor.newInstance();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return TestUtils.newInstance(Type.valueOf(clazz).toString());
    }

    public static <T extends ConfigurationItem> T newInstance(Class<T> clazz, String id) {
        ConfigurationItem instance = (ConfigurationItem)TestUtils.newInstance(Type.valueOf(clazz).toString());
        instance.setId(id);
        return (T)instance;
    }

    public static <T extends ConfigurationItem> T newInstance(String type, String id) {
        ConfigurationItem instance = (ConfigurationItem)TestUtils.newInstance(type);
        instance.setId(id);
        return (T)instance;
    }

    public static String id(String ... names) {
        return Joiner.on((char)'/').join((Object[])names);
    }

    public static DeploymentPackage createDeploymentPackage(Deployable ... deployables) {
        return TestUtils.createDeploymentPackage("1.0", deployables);
    }

    public static DeploymentPackage createDeploymentPackage(String version, Deployable ... deployables) {
        Application app = TestUtils.newInstance(Application.class);
        app.setId(TestUtils.id("Applications", "Test"));
        DeploymentPackage pkg = TestUtils.newInstance(DeploymentPackage.class);
        pkg.setId(TestUtils.id(pkg.getId(), version));
        pkg.setApplication(app);
        for (Deployable deployable : deployables) {
            deployable.setId(TestUtils.id(app.getId(), deployable.getId()));
            pkg.addDeployable(deployable);
        }
        return pkg;
    }

    public static Environment createEnvironment(Container ... containers) {
        Environment env = TestUtils.newInstance(Environment.class);
        env.setId(TestUtils.id("Environments", "JUnit"));
        HashSet containerSet = Sets.newHashSet();
        containerSet.addAll(Arrays.asList(containers));
        env.setMembers((Set)containerSet);
        return env;
    }

    public static DeployedApplication createDeployedApplication(DeploymentPackage pkg, Environment env) {
        return DeltaSpecifications.createDeployedApplication((Version)pkg, env);
    }

    public static <T extends SourceArtifact> T createArtifact(String name, String version, String classpathResource, String type, File workingFolder) throws IOException {
        SourceArtifact artifact = (SourceArtifact)TestUtils.newInstance(type);
        artifact.setId(TestUtils.id("Applications", "Test", version, name));
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        File artifactFile = new File(workingFolder, artifact.getName());
        artifactFile.createNewFile();
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)artifactURL), (File)artifactFile);
        artifact.setFile(LocalFile.valueOf((File)artifactFile));
        return (T)artifact;
    }

    public static <T extends SourceArtifact> T createArtifactWithoutCopy(String name, String version, String classpathResource, String type, File workingFolder) throws URISyntaxException {
        SourceArtifact artifact = (SourceArtifact)TestUtils.newInstance(type);
        artifact.setId(TestUtils.id("Applications", "Test", version, name));
        URL artifactURL = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
        artifact.setFile(LocalFile.valueOf((File)new File(artifactURL.toURI().getPath())));
        return (T)artifact;
    }
}

