/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.deployment;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import java.util.ArrayList;
import java.util.List;

public class PlanUtils {
    public static List<StepPlan.StepWithDelta> flattenPlan(Plan serialPlan) {
        ArrayList stepsWithDelta = Lists.newArrayList();
        for (Plan plan : ((SerialPlan)serialPlan).getSubPlans()) {
            if (plan instanceof StepPlan) {
                stepsWithDelta.addAll(((StepPlan)plan).getStepsWithDelta());
                continue;
            }
            if (plan instanceof SerialPlan) {
                stepsWithDelta.addAll(PlanUtils.flattenPlan(plan));
                continue;
            }
            throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
        }
        return stepsWithDelta;
    }

    public static List<StepPlan.Checkpoint> resolveCheckpoints(Plan plan) {
        ArrayList checkpoints = Lists.newArrayList();
        if (plan instanceof SerialPlan) {
            for (Plan subPlan : ((SerialPlan)plan).getSubPlans()) {
                checkpoints.addAll(PlanUtils.resolveCheckpoints(subPlan));
            }
        } else if (plan instanceof StepPlan) {
            checkpoints.addAll(((StepPlan)plan).getCheckpoints());
        } else {
            throw new RuntimeException("Can not flatten " + plan.getClass().getSimpleName());
        }
        return checkpoints;
    }
}

