package com.xebialabs.deployit.test.support;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.test.repository.InMemoryRepository;

import static com.google.common.collect.Lists.newArrayList;

public class CapturingExecutionContext extends TestExecutionContext {

    protected List<String> capturedOutput = newArrayList();
    protected List<String> capturedError = newArrayList();

    public CapturingExecutionContext() {
        super(InMemoryRepository.REFERENCE.get());
    }

    public CapturingExecutionContext(Class<?> clazz) {
        super(clazz, InMemoryRepository.REFERENCE.get());
    }
    public CapturingExecutionContext(String taskId, Class<?> clazz) {
        super(taskId, clazz, InMemoryRepository.REFERENCE.get());
    }

    public CapturingExecutionContext(Repository repository) {
        super(repository);
    }

    public CapturingExecutionContext(Class<?> clazz, Repository repository) {
        super(clazz, repository);
    }

    public CapturingExecutionContext(String taskId, Class<?> clazz, Repository repository) {
        super(taskId, clazz, repository);
    }

    @Override
    public void logOutput(String output) {
        super.logOutput(output);
        this.capturedOutput.add(output);
    }

    @Override
    public void logError(String error) {
        super.logError(error);
        this.capturedError.add(error);
    }

    @Override
    public void logError(String error, Throwable t) {
        super.logError(error, t);
        this.capturedError.add(error);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.capturedError.add(sw.toString());
        }
    }

    public List<String> getCapturedOutput() {
        return capturedOutput;
    }

    public List<String> getCapturedError() {
        return capturedError;
    }

}
