/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.jbossas.ci;

import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.Discoverable;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.jbossas.ci.JbossasVersion;
import com.xebialabs.deployit.plugin.jbossas.step.CheckJbossasServerVersion;
import com.xebialabs.deployit.step.CheckDirExistsStep;
import com.xebialabs.deployit.step.CheckFileExistenceStep;
import com.xebialabs.deployit.step.HostConnectionStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="JBoss Application Server instance", discoverable=true, category="middleware")
public class JbossasServer
extends BaseConfigurationItem
implements Discoverable<JbossasServer> {
    public static final int DEPLOYMENT_COMPLETION_WAIT_TIME_MILLIS = 10000;
    @ConfigurationItemProperty(required=true, label="JBoss version", description="Version of the JBoss serve.r")
    private JbossasVersion version;
    @ConfigurationItemProperty(required=true, label="JBoss server host", description="Host on which the JBoss server is running.")
    private Host host;
    @ConfigurationItemProperty(required=true, label="JBoss installation location", description="Place where JBoss is installed such as /usr/local/jboss-5.1.0.GA.", size=ConfigurationItemProperty.Size.LARGE, discoveryParam=true)
    private String home;
    @ConfigurationItemProperty(required=true, label="JBoss instance name", description="Name of the JBoss server instance, e.g. default or minimal.", discoveryParam=true)
    private String name;
    @ConfigurationItemProperty(required=false, label="JBoss restart command", description="Command that should be executed to restart the JBoss server.", size=ConfigurationItemProperty.Size.LARGE)
    private String restartCommand;
    @ConfigurationItemProperty(required=false, description="AJP Port for the JBoss Server, default is 8009")
    private int ajpPort = 8009;

    public HostSession connectToAdminHost() {
        return this.getHost().getHostSession();
    }

    public String getRunJarFilePath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "bin" + fileSep + "run.jar";
    }

    public String getInstanceDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getHome() + fileSep + "server" + fileSep + this.getName();
    }

    public String getDeployDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getInstanceDirPath() + fileSep + "deploy";
    }

    public JbossasVersion getVersion() {
        return this.version;
    }

    public void setVersion(JbossasVersion version) {
        this.version = version;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRestartCommand() {
        return this.restartCommand;
    }

    public void setRestartCommand(String restartCommand) {
        this.restartCommand = restartCommand;
    }

    public String getTmpDirPath() {
        String fileSep = this.getHost().getFileSeparator();
        return this.getInstanceDirPath() + fileSep + "tmp";
    }

    public int getAjpPort() {
        return this.ajpPort;
    }

    public void setAjpPort(int ajpPort) {
        this.ajpPort = ajpPort;
    }

    private List<Step> getCheckSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add((Step)new HostConnectionStep(this.getHost()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getHome()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getInstanceDirPath()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getDeployDirPath()));
        steps.add((Step)new CheckDirExistsStep(this.getHost(), this.getTmpDirPath()));
        steps.add(new CheckJbossasServerVersion(this));
        if (StringUtils.isNotEmpty((String)this.getRestartCommand())) {
            steps.add((Step)new CheckFileExistenceStep(this.getHost(), this.getRestartCommand(), true, false, true));
        }
        return steps;
    }

    public JbossasServer discover(Map<String, Object> info, ChangePlan cp) {
        List<Step> steps = this.getCheckSteps();
        cp.addSteps(steps);
        cp.execute(info);
        return this;
    }

    public JbossasServer discoverChildrenInfo(Map<String, Object> info, ChangePlan cp) {
        return null;
    }
}

