package com.xebialabs.license;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;

/**
 * Property names used in license file
 */
public enum LicenseProperty {
    LICENSED_TO("Licensed to", true),
    CONTACT("Contact", true),
    EXPIRES_AFTER("Expires after", true),
    PRODUCT("Product", true),
    REPOSITORY_ID("Repository id", false),
    MAX_NUMBER_OF_USERS("Maximum number of users", false);

    private static Map<String, LicenseProperty> lookup = newHashMap();
    static {
        for (LicenseProperty e : LicenseProperty.values()) {
            lookup.put(e.getName(), e);
        }
    }

    private final String name;
    private final boolean required;

    LicenseProperty(String name, boolean required) {
        this.name = name;
        this.required = required;
    }

    public static LicenseProperty get(String name) {
        return lookup.get(name);
    }

    public static int getLongerNameLength() {
        int maxLength = 0;
        for (LicenseProperty licenseProperty : LicenseProperty.values()) {
            int length = licenseProperty.getName().length();
            if (length > maxLength) {
                maxLength = length;
            }
        }
        return maxLength;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return required;
    }
}
