/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.collect.Maps;
import java.util.Map;

public enum LicenseProperty {
    LICENSED_TO("Licensed to", true),
    CONTACT("Contact", true),
    EXPIRES_AFTER("Expires after", true),
    PRODUCT("Product", true),
    REPOSITORY_ID("Repository id", false),
    MAX_NUMBER_OF_USERS("Maximum number of users", false);

    private static Map<String, LicenseProperty> lookup;
    private final String name;
    private final boolean required;

    private LicenseProperty(String name, boolean required) {
        this.name = name;
        this.required = required;
    }

    public static LicenseProperty get(String name) {
        return lookup.get(name);
    }

    public static int getLongerNameLength() {
        int maxLength = 0;
        for (LicenseProperty licenseProperty : LicenseProperty.values()) {
            int length = licenseProperty.getName().length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    static {
        lookup = Maps.newHashMap();
        for (LicenseProperty e : LicenseProperty.values()) {
            lookup.put(e.getName(), e);
        }
    }
}

