/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.google.common.collect.Maps;
import com.xebialabs.license.LicensePropertyType;
import java.util.Map;

public enum LicenseProperty {
    LICENSE_VERSION("License version", true, LicensePropertyType.STRING),
    LICENSED_TO("Licensed to", true, LicensePropertyType.STRING),
    CONTACT("Contact", true, LicensePropertyType.STRING),
    PRODUCT("Product", true, LicensePropertyType.STRING),
    EXPIRES_AFTER("Expires after", false, LicensePropertyType.DATE),
    REPOSITORY_ID("Repository id", false, LicensePropertyType.STRING),
    MAX_NUMBER_OF_USERS("Maximum number of users", false, LicensePropertyType.STRING),
    MAX_NUMBER_OF_CIS("Licensed number of CIs", false, LicensePropertyType.MAP_STRING_INTEGER),
    LICENSED_PLUGINS("Licensed plugin", false, LicensePropertyType.LIST_OF_STRINGS),
    SUPPORT_POLICY("Support policy", false, LicensePropertyType.STRING);

    private static Map<String, LicenseProperty> lookup;
    private final String name;
    private final boolean required;
    private final LicensePropertyType type;

    private LicenseProperty(String name, boolean required, LicensePropertyType type) {
        this.name = name;
        this.required = required;
        this.type = type;
    }

    public static LicenseProperty get(String name) {
        return lookup.get(name);
    }

    public static int getLongerNameLength() {
        int maxLength = 0;
        for (LicenseProperty licenseProperty : LicenseProperty.values()) {
            int length = licenseProperty.getName().length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public LicensePropertyType getType() {
        return this.type;
    }

    static {
        lookup = Maps.newHashMap();
        for (LicenseProperty e : LicenseProperty.values()) {
            lookup.put(e.getName(), e);
        }
    }
}

