/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.xebia.ad.DeployItConfiguration;
import com.xebia.ad.ReleaseInfo;
import com.xebia.ad.Server;
import com.xebia.ad.cli.Interpreter;
import com.xebia.ad.setup.SetupDatabaseType;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.DeployableArtifactItem;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String artifactId;
    protected String version;
    protected String packaging;
    protected boolean testmode;
    protected File jeeArtifact;
    private int port;
    protected String[] commands;
    protected List<ConfigurationItem> middlewareResources;
    protected List<ConfigurationItem> mappings;
    protected List<ConfigurationItem> environment;
    protected List<DeployableArtifactItem> deployableArtifacts;
    protected boolean generateManifestOnly;
    private final StringBuffer fullScript = new StringBuffer();
    private Interpreter interpreter;
    public static final String DEFAULT_ENVIRONMENT = "DefaultEnvironment";
    public static final String DEFAULT_DEPLOYMENT = "DefaultDeployment";
    private static boolean SERVER_STARTED = false;

    protected void startServer() {
        if (!SERVER_STARTED) {
            this.getLog().info((CharSequence)"STARTING DEPLOYIT SERVER");
            DeployItConfiguration context = new DeployItConfiguration();
            context.setDatabaseType(SetupDatabaseType.HSQLDB);
            context.setDatabaseDriverClass(SetupDatabaseType.getDefaultDatabaseDriverClass((SetupDatabaseType)context.getDatabaseType()));
            context.setHibernateDialect(SetupDatabaseType.getHibernateDialect((SetupDatabaseType)context.getDatabaseType()));
            context.setDatabaseURL("jdbc:hsqldb:file:" + new File(this.outputDirectory, "./deployit.hdb").getPath() + ";shutdown=true");
            context.setDatabaseUsername(SetupDatabaseType.getDefaultUsername((SetupDatabaseType)context.getDatabaseType()));
            context.setDatabasePassword("");
            File deployitRepoDir = new File(this.outputDirectory, "deployit.repo");
            deployitRepoDir.mkdir();
            context.setApplicationRepositoryPath(deployitRepoDir.getPath());
            context.setHttpPort(this.getPort());
            context.setApplicationToDeployPath("importablePackages");
            context.setMinThreads(10);
            context.setMaxThreads(50);
            context.setSecured(false);
            context.setHttpServerName("localhost");
            context.save();
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"ad-repository", (Map)context.getCreationalJPAProperties());
            emf.close();
            Server s = new Server(context, ReleaseInfo.getReleaseInfo());
            s.start();
            this.getLog().info((CharSequence)"STARTED DEPLOYIT SERVER");
            SERVER_STARTED = true;
        }
    }

    public static void stopServer() {
        Server.shutdown();
        SERVER_STARTED = false;
    }

    protected void interpret(String line) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Interpret [" + line + "]"));
        this.fullScript.append(line).append('\n');
        this.getInterpreter().interpretAndThrowExceptions(line);
    }

    protected void interpret(List<String> cliCommands) throws MojoExecutionException {
        for (String cmd : cliCommands) {
            this.interpret(cmd);
        }
    }

    protected Interpreter getInterpreter() throws MojoExecutionException {
        if (this.interpreter == null) {
            System.setProperty("cli.protocol", "http");
            ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"/cli/unsecured/ad-cli-context.xml"});
            this.interpreter = (Interpreter)ctx.getBean("interpreter");
            if (this.interpreter == null) {
                throw new MojoExecutionException("Cannot find interpreter");
            }
            this.interpreter.afterPropertiesSet();
        }
        return this.interpreter;
    }

    protected void deployit() throws MojoExecutionException {
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)"--- DEPLOYIT CHANGE PLAN  ----------------------------------------");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.interpret("changeplan steps");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)"------------------------------------------------------------------");
        this.getLog().info((CharSequence)" ");
        this.getLog().info((CharSequence)" ");
        if (this.testmode) {
            this.interpret("deployit_nosteps");
        } else {
            this.interpret("deployit");
        }
        this.interpret("changeplan changes");
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public boolean isTestmode() {
        return this.testmode;
    }

    public void setTestmode(boolean testmode) {
        this.testmode = testmode;
    }

    public File getJeeArtifact() {
        return this.jeeArtifact;
    }

    public void setJeeArtifact(File jeeArtifact) {
        this.jeeArtifact = jeeArtifact;
    }

    public int getPort() {
        return this.port == 0 ? 8888 : this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String[] getCommands() {
        return this.commands;
    }

    public void setCommands(String[] commands) {
        this.commands = commands;
    }

    public List<ConfigurationItem> getMiddlewareResources() {
        return this.middlewareResources;
    }

    public void setMiddlewareResources(List<ConfigurationItem> middlewareResources) {
        this.middlewareResources = middlewareResources;
    }

    public List<ConfigurationItem> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<ConfigurationItem> mappings) {
        this.mappings = mappings;
    }

    public List<ConfigurationItem> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(List<ConfigurationItem> environment) {
        this.environment = environment;
    }

    public String getScript() {
        return this.fullScript.toString();
    }

    protected DeployableArtifactItem getRealDeployableArtifact(DeployableArtifactItem item) throws MojoExecutionException {
        if (!item.getLocation().contains(":")) {
            this.getLog().info((CharSequence)(" add a deployable artifact " + item));
            return item;
        }
        this.getLog().info((CharSequence)(" add a maven deployable artifact " + item));
        this.getLog().debug((CharSequence)("-translateIntoPath- " + item.getLocation()));
        String key = item.getLocation();
        Artifact artifact = (Artifact)this.project.getArtifactMap().get(key);
        if (artifact == null) {
            throw new MojoExecutionException("The artifact " + key + " referenced in plugin as is not found the project dependencies");
        }
        DeployableArtifactItem mavenDeployableArtifact = new DeployableArtifactItem();
        mavenDeployableArtifact.setLocation(artifact.getFile().toString());
        if (item.hasName()) {
            mavenDeployableArtifact.setName(item.getName());
        } else {
            mavenDeployableArtifact.setName(artifact.getArtifactId());
        }
        mavenDeployableArtifact.setType(item.getType());
        mavenDeployableArtifact.setDarLocation(item.getDarLocation());
        return mavenDeployableArtifact;
    }

    protected DeployableArtifactItem getRealDeployableArtifact(Artifact artifact) throws MojoExecutionException {
        DeployableArtifactItem mavenDeployableArtifact = new DeployableArtifactItem();
        mavenDeployableArtifact.setLocation(artifact.getFile().toString());
        mavenDeployableArtifact.setName(artifact.getArtifactId());
        mavenDeployableArtifact.setType(this.capitalize(artifact.getType()));
        return mavenDeployableArtifact;
    }

    private String capitalize(String inputWord) {
        String firstLetter = inputWord.substring(0, 1);
        String remainder = inputWord.substring(1);
        String capitalized = firstLetter.toUpperCase() + remainder.toLowerCase();
        return capitalized;
    }
}

