/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.xebialabs.deployit.maven.AbstractDeployitMojo;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.DeployableArtifactItem;
import com.xebialabs.deployit.maven.packager.ManifestPackager;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DeployMojo
extends AbstractDeployitMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"deployit:deploy");
        if (this.environment == null) {
            throw new MojoExecutionException("Environment is empty");
        }
        ManifestPackager packager = new ManifestPackager(this.artifactId, this.version, this.outputDirectory);
        packager.setGenerateManifestOnly(this.generateManifestOnly);
        this.getLog().info((CharSequence)"create the main artifact");
        packager.addDeployableArtifact(this.getRealDeployableArtifact(this.project.getArtifact()));
        if (this.deployableArtifacts != null) {
            this.getLog().info((CharSequence)"create the additional artifacts");
            for (DeployableArtifactItem item : this.deployableArtifacts) {
                packager.addDeployableArtifact(this.getRealDeployableArtifact(item));
            }
        }
        packager.perform();
        this.startServer();
        this.interpret(packager.getCliCommands());
        this.getLog().info((CharSequence)"Create the environment");
        ArrayList<String> members = new ArrayList<String>();
        for (ConfigurationItem each : this.environment) {
            this.interpret(each.getCli());
            if (!each.isAddedToEnvironment()) continue;
            members.add(each.getLabel());
        }
        this.interpret("create Environment label=DefaultEnvironment");
        for (String member : members) {
            this.interpret("modify DefaultEnvironment members += \"" + member + "\" ");
        }
        if (this.middlewareResources != null) {
            this.getLog().info((CharSequence)"create Middleware Resources");
            for (ConfigurationItem ci : this.middlewareResources) {
                this.interpret(ci.getCli());
                this.interpret("modify \"" + packager.getDeploymentPackageName() + "\" middlewareResources+=\"" + ci.getLabel() + "\"");
            }
        }
        if (this.commands != null) {
            this.getLog().info((CharSequence)"Handle additional commands");
            for (String each : this.commands) {
                this.interpret(each);
            }
        }
        this.getLog().info((CharSequence)"Create the Deployment");
        StringBuilder depCmd = new StringBuilder("create Deployment ");
        depCmd.append("label=DefaultDeployment").append(' ');
        depCmd.append("source=").append('\"').append(packager.getDeploymentPackageName()).append('\"').append(' ');
        depCmd.append("target=DefaultEnvironment");
        this.interpret(depCmd.toString());
        if (this.mappings != null) {
            this.getLog().info((CharSequence)"create Mappings");
            for (ConfigurationItem ci : this.mappings) {
                this.interpret(ci.getCli());
            }
        }
        this.deployit();
        this.getLog().info((CharSequence)"end of deploy:deploy");
    }
}

