/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.xebialabs.deployit.maven.AbstractDeployitMojo;
import com.xebialabs.deployit.maven.DeployableArtifactItem;
import com.xebialabs.deployit.maven.packager.ManifestPackager;
import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class GenerateDeploymentPackageMojo
extends AbstractDeployitMojo {
    private JarArchiver jarArchiver;
    private String finalName;
    private String classifier;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Build the Deployit Deployment Package");
        ManifestPackager packager = new ManifestPackager(this.artifactId, this.version, this.outputDirectory);
        packager.setGenerateManifestOnly(this.generateManifestOnly);
        this.getLog().info((CharSequence)"Generate Deployment Package...");
        if (this.deployableArtifacts != null) {
            this.getLog().info((CharSequence)"create the artifacts");
            for (DeployableArtifactItem item : this.deployableArtifacts) {
                packager.addDeployableArtifact(this.getRealDeployableArtifact(item));
            }
        }
        packager.perform();
        this.getLog().info((CharSequence)("Manifest file generated in " + packager.getManifestFile()));
        if (this.generateManifestOnly) {
            this.getLog().info((CharSequence)"Do not seal the dar file, return");
            return;
        }
        try {
            File darFile = GenerateDeploymentPackageMojo.getDarFile(this.outputDirectory, this.finalName, this.classifier);
            this.getLog().info((CharSequence)("Seal the archive in " + darFile));
            MavenArchiver mvnArchiver = new MavenArchiver();
            this.getLog().debug((CharSequence)("Jar archiver implementation[" + this.jarArchiver.getClass().getName() + "]"));
            mvnArchiver.setArchiver(this.jarArchiver);
            mvnArchiver.setOutputFile(darFile);
            mvnArchiver.getArchiver().addDirectory(packager.getTargetDirectory());
            File manifestFile = packager.getManifestFile();
            this.getLog().debug((CharSequence)("set Manifest file of the archive " + manifestFile));
            mvnArchiver.getArchiver().setManifest(manifestFile);
            mvnArchiver.createArchive(this.getProject(), this.archive);
            if (this.classifier != null) {
                this.projectHelper.attachArtifact(this.getProject(), "dar", this.classifier, darFile);
            } else {
                this.getProject().getArtifact().setFile(darFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling DAR", e);
        }
    }

    private static File getDarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".dar");
    }

    public JarArchiver getJarArchiver() {
        return this.jarArchiver;
    }
}

