/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.converter;

import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.MappingItem;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;

public class DeployitCIConverter
extends AbstractConfigurationConverter {
    public static final String MAVEN_EXPRESSION_EVALUATOR_ID = "maven.expressionEvaluator";
    public static final String ROLE = ConfigurationConverter.class.getName();
    static final String TYPE = "type";
    static final String ADD_TO_ENV = "addToEnv";

    public boolean canConvert(Class type) {
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (type.equals(ConfigurationItem.class)) {
            ConfigurationItem ci = new ConfigurationItem();
            try {
                String typeAttribute = configuration.getAttribute(TYPE);
                if (typeAttribute != null) {
                    throw new ComponentConfigurationException("'Type' xml attribute is no more supported, use <type>" + typeAttribute + "</type> instead");
                }
                String add2Env = configuration.getAttribute(ADD_TO_ENV);
                if (add2Env != null) {
                    ci.setAddedToEnvironment(Boolean.parseBoolean(add2Env));
                }
            }
            catch (Exception e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            for (PlexusConfiguration plexusConfiguration : configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    ci.addParameter(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ci;
        }
        if (type.equals(MappingItem.class)) {
            PlexusConfiguration[] children;
            MappingItem ci = new MappingItem();
            PlexusConfiguration source = configuration.getChild("source");
            PlexusConfiguration target = configuration.getChild("target");
            PlexusConfiguration mainType = configuration.getChild(TYPE);
            try {
                ci.setSource(source.getValue());
                ci.setTarget(target.getValue());
                ci.setMainType(mainType.getValue());
            }
            catch (PlexusConfigurationException e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            try {
                String typeAttribute = configuration.getAttribute(TYPE);
                if (typeAttribute != null) {
                    throw new ComponentConfigurationException("'Type' xml attribute is no more supported, use <type>" + typeAttribute + "</type> instead");
                }
            }
            catch (Exception e) {
                throw new ComponentConfigurationException("getValue error", (Throwable)e);
            }
            for (PlexusConfiguration plexusConfiguration : children = configuration.getChildren()) {
                try {
                    String name = plexusConfiguration.getName();
                    String c = plexusConfiguration.getValue();
                    ci.addParameter(name, c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return ci;
        }
        throw new ComponentConfigurationException("type not handled (" + type + ")");
    }
}

