/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.xebialabs.deployit.maven.DeployableArtifactItem;
import com.xebialabs.deployit.maven.packager.ApplicationDeploymentPackager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestPackager
implements ApplicationDeploymentPackager {
    private final File targetDirectory;
    private final String deploymentPackageName;
    private final Manifest manifest = new Manifest();
    private static final String DEPLOYMENT_PACKAGE_DIR = "deployment-package";
    private boolean generateManifestOnly = false;

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public ManifestPackager(String artifactId, String version, File targetDirectory) {
        this.targetDirectory = new File(targetDirectory, DEPLOYMENT_PACKAGE_DIR + File.separator + artifactId + File.separator + version);
        this.targetDirectory.mkdirs();
        this.deploymentPackageName = artifactId + "/" + version;
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Deployit-Package-Format-Version", "1.1");
        mainAttributes.putValue("CI-Application", artifactId);
        mainAttributes.putValue("CI-Version", version);
    }

    @Override
    public void perform() {
        File meta_inf = new File(this.targetDirectory, "META-INF");
        meta_inf.mkdirs();
        File manifestFile = new File(meta_inf, "MANIFEST.MF");
        try {
            FileOutputStream fos = new FileOutputStream(manifestFile);
            this.manifest.write(fos);
            fos.close();
        }
        catch (IOException e) {
            new RuntimeException("perform failed", e);
        }
    }

    @Override
    public String getDeploymentPackageName() {
        return this.deploymentPackageName;
    }

    @Override
    public List<String> getCliCommands() {
        ArrayList<String> a = new ArrayList<String>();
        a.add("import location=" + this.targetDirectory);
        a.add("show");
        a.add("show_type");
        a.add("show_type DeploymentPackage");
        return a;
    }

    @Override
    public void addDeployableArtifact(DeployableArtifactItem item) {
        File locationTargetDirs;
        String darLocation;
        if ("Dar".equals(item.getType())) {
            return;
        }
        if ("Pom".equals(item.getType())) {
            return;
        }
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        String type = item.getType();
        File location = new File(item.getLocation());
        attributes.putValue("CI-Type", type);
        if (item.hasName()) {
            attributes.putValue("CI-Name", item.getName());
        }
        String string = darLocation = item.getDarLocation() == null ? type : item.getDarLocation();
        if (item.isFolder()) {
            entries.put(darLocation, attributes);
        } else if (location.isAbsolute()) {
            entries.put(darLocation + "/" + location.getName(), attributes);
        } else {
            entries.put(darLocation + "/" + item.getLocation(), attributes);
        }
        File targetDir = new File(this.targetDirectory, darLocation);
        if (this.generateManifestOnly) {
            System.out.println("Skip copying artifact " + item.getName() + " to " + targetDir);
            return;
        }
        targetDir.mkdirs();
        if (location.isAbsolute() || location.getParent() == null) {
            locationTargetDirs = targetDir;
        } else {
            locationTargetDirs = new File(targetDir, location.getParent());
            locationTargetDirs.mkdirs();
        }
        try {
            if (location.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)location, (File)locationTargetDirs);
            } else {
                FileUtils.copyFileToDirectory((File)location, (File)locationTargetDirs);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to copy of " + location + " to " + targetDir, e);
        }
    }

    public boolean isGenerateManifestOnly() {
        return this.generateManifestOnly;
    }

    public void setGenerateManifestOnly(boolean generateManifestOnly) {
        this.generateManifestOnly = generateManifestOnly;
    }

    public File getManifestFile() {
        return new File(this.targetDirectory, "META-INF/MANIFEST.MF");
    }
}

