/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.DeployableArtifactItem;
import com.xebialabs.deployit.maven.MappingItem;
import com.xebialabs.deployit.maven.MavenCli;
import com.xebialabs.deployit.maven.MiddlewareResource;
import com.xebialabs.deployit.maven.packager.ManifestPackager;
import java.io.File;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDeployitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String artifactId;
    protected boolean testmode;
    protected boolean remoteServerMode = true;
    private String serverAddress;
    private int port;
    private String username;
    private String password;
    private String environmentId = "Environments/DefaultEnvironment";
    protected List<MiddlewareResource> middlewareResources;
    protected List<MappingItem> mappings;
    protected List<ConfigurationItem> environment;
    protected List<DeployableArtifactItem> deployableArtifacts;
    protected boolean generateManifestOnly;
    protected boolean timestampedVersion;
    protected boolean deletePreviouslyDeployedDar;
    protected ManifestPackager packager;
    protected MavenCli client;
    public static final String DEFAULT_ENVIRONMENT = "Environments/DefaultEnvironment";
    public static final String DEFAULT_DEPLOYMENT = "DefaultDeployment";

    private boolean isServerStarted() {
        this.getLog().debug((CharSequence)("Check if the server is started on port " + this.port));
        try {
            ServerSocket socket = new ServerSocket(this.port);
            socket.close();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)("The server is started on " + this.port), (Throwable)e);
            return true;
        }
        this.getLog().debug((CharSequence)("The server is not started on " + this.port));
        return false;
    }

    protected MavenCli getClient() throws MojoExecutionException {
        if (this.client == null) {
            this.client = new MavenCli(this.serverAddress, this.port, this.username, this.password, this.getLog());
            this.client.setSkipStepsMode(this.testmode);
        }
        return this.client;
    }

    protected void deploy() throws MojoExecutionException {
        RepositoryObject deploymentPackage = this.importDar();
        RepositoryObject environment = this.fetchEnvironment();
        String application = (String)deploymentPackage.getValues().get("application");
        String version = (String)deploymentPackage.getValues().get("version");
        this.getLog().info((CharSequence)String.format("-- Deploy %s on %s", deploymentPackage.getId(), environment.getId()));
        String previousPackageId = this.getClient().deployAndWait(deploymentPackage.getId(), environment.getId(), this.getMappings(application, version));
        if (this.deletePreviouslyDeployedDar && StringUtils.isNotBlank((String)previousPackageId)) {
            this.getLog().info((CharSequence)("Delete previously deployed dar " + previousPackageId));
            this.getClient().delete(previousPackageId);
        }
    }

    protected RepositoryObject importDar() throws MojoExecutionException {
        File darFile = this.getPackager().getDarFile();
        if (!darFile.exists()) {
            this.getLog().info((CharSequence)("Dar file does not exist " + darFile));
            this.getLog().info((CharSequence)"generate it...");
            this.getPackager().perform();
            this.getPackager().seal();
        }
        return this.importDar(darFile);
    }

    private List<MappingItem> getMappings(final String application, final String version) {
        if (this.mappings == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.mappings, (Function)new Function<MappingItem, MappingItem>(){

            public MappingItem apply(MappingItem mappingItem) {
                String source = mappingItem.getSource();
                if (!source.startsWith("Applications")) {
                    mappingItem.setSource(String.format("%s/%s/%s", application, version, source));
                    AbstractDeployitMojo.this.getLog().info((CharSequence)(" mapping translation " + source + " --> " + mappingItem.getSource()));
                }
                return mappingItem;
            }
        });
    }

    protected void undeploy() throws MojoExecutionException {
        this.getClient().undeployAndWait(this.environmentId + "/" + this.artifactId);
    }

    protected RepositoryObject importDar(File darFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Import dar file " + darFile));
        return this.getClient().importPackage(darFile);
    }

    protected RepositoryObject fetchEnvironment() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("read the environment " + this.environmentId));
            RepositoryObject repositoryObject = this.getClient().get(this.environmentId);
            if (this.getLog().isDebugEnabled() && repositoryObject != null) {
                this.getLog().debug((CharSequence)(" dump members of " + this.environmentId));
                for (Object m : (List)repositoryObject.getValues().get("members")) {
                    this.getLog().debug((CharSequence)("  -- member " + m));
                }
            }
            return repositoryObject;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.getMessage());
            if (this.environment == null) {
                throw new MojoExecutionException("Cannot fetch environment " + this.environmentId + " and not members are defined in <environnment>", e);
            }
            this.getLog().info((CharSequence)"Create the members of environment");
            ArrayList members = Lists.newArrayList();
            for (ConfigurationItem each : this.environment) {
                this.getLog().info((CharSequence)(" create " + each.getLabel()));
                this.getClient().create(each);
                if (!each.isAddedToEnvironment()) continue;
                members.add(each.getLabel());
            }
            this.getLog().info((CharSequence)("Create environment " + this.environmentId));
            ConfigurationItem ciEnvironment = new ConfigurationItem();
            ciEnvironment.setLabel(this.environmentId);
            ciEnvironment.setType("Environment");
            ciEnvironment.addParameter("members", members);
            return this.getClient().create(ciEnvironment);
        }
    }

    ManifestPackager getPackager() {
        if (this.packager == null) {
            this.packager = new ManifestPackager(this.project);
            this.packager.setLog(this.getLog());
            this.packager.setGenerateManifestOnly(this.generateManifestOnly);
            this.packager.setTimestampedVersion(this.timestampedVersion);
            this.packager.addDeployableArtifact(this.project.getArtifact());
            this.packager.addDeployableArtifacts(this.deployableArtifacts);
            this.packager.addMiddlewareResources(this.middlewareResources);
        }
        return this.packager;
    }
}

