/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.xebialabs.deployit.maven.PackagedItem;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class DeployableArtifactItem
implements PackagedItem {
    private String type;
    private String location;
    private String name;
    private String darLocation;
    private String fileSystemLocation;
    private boolean folder = false;

    public String getDarLocation() {
        return this.darLocation == null ? this.type : this.darLocation;
    }

    public void setDarLocation(String darLocation) {
        this.darLocation = darLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFolder() {
        if ("ConfigurationFiles".equals(this.type)) {
            return true;
        }
        if ("Libraries".equals(this.type)) {
            return true;
        }
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public String toString() {
        return "DeployableArtifactItem{type='" + this.type + '\'' + ", location='" + this.location + '\'' + ", name='" + this.name + '\'' + ", darLocation='" + this.darLocation + '\'' + ", folder=" + this.isFolder() + ", fileSysLoc=" + this.getFileSystemLocation() + '}';
    }

    public boolean hasName() {
        return !StringUtils.isBlank((String)this.name);
    }

    public String getFileSystemLocation() {
        return this.fileSystemLocation;
    }

    public void setFileSystemLocation(String fileSystemLocation) {
        this.fileSystemLocation = fileSystemLocation;
    }

    @Override
    public String getEntryKey() {
        File syslocation = new File(this.getFileSystemLocation());
        String darLocation = this.getDarLocation();
        if (this.isFolder() && syslocation.isFile()) {
            return darLocation;
        }
        return darLocation + "/" + syslocation.getName();
    }
}

