/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.cli.CliOptions;
import com.xebialabs.deployit.cli.api.DeployitClient;
import com.xebialabs.deployit.cli.api.ObjectFactory;
import com.xebialabs.deployit.cli.api.Proxies;
import com.xebialabs.deployit.cli.api.RepositoryClient;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.RepositoryObjects;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.Steps;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.core.api.resteasy.DeployitClientException;
import com.xebialabs.deployit.maven.ConfigurationItem;
import com.xebialabs.deployit.maven.MappingItem;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class MavenCli {
    private final CliOptions options = new CliOptions();
    private final HttpClient client;
    private final Proxies proxies;
    private final ObjectFactory factory;
    private final RepositoryClient repositoryClient;
    private final DeployitClient deployitClient;
    private Log logger;
    private boolean testMode = false;

    public MavenCli(String serverAddress, int port, String username, String password, Log log) {
        if (StringUtils.isNotBlank((String)serverAddress)) {
            this.options.setHost(serverAddress);
        }
        this.options.setPort(port);
        this.options.setExposeProxies(true);
        this.options.setUsername(StringUtils.isBlank((String)username) ? "admin" : username);
        this.options.setPassword(StringUtils.isBlank((String)password) ? "admin" : password);
        this.client = this.getAuthenticatingHttpClient();
        this.proxies = new Proxies(this.options, this.client);
        this.factory = new ObjectFactory(this.proxies);
        this.repositoryClient = new RepositoryClient(this.proxies);
        this.deployitClient = new DeployitClient(this.proxies);
        this.setLogger(log);
        this.attemptToConnectToServer();
    }

    private HttpClient getAuthenticatingHttpClient() {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.options.getUsername(), this.options.getPassword());
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        httpClient.getParams().setConnectionManagerTimeout(30000L);
        return httpClient;
    }

    private void attemptToConnectToServer() {
        String urlToConnectTo = this.options.getUrl();
        System.out.println("Connecting to the Deployit server at " + urlToConnectTo + "...");
        try {
            int responseCode = this.client.executeMethod((HttpMethod)new GetMethod(urlToConnectTo + "/deployit/server/info"));
            if (responseCode != 200) {
                if (responseCode == 401 || responseCode == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
            }
            System.out.println("Succesfully connected.");
        }
        catch (Exception e) {
            this.logger.error((CharSequence)("Could not contact the server at " + urlToConnectTo + ":" + e));
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
        }
    }

    public RepositoryObject create(ConfigurationItem ci) {
        String id = ci.getLabel();
        try {
            return this.get(id);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)String.format("%s does not exist, create it", id));
            Response response = this.getProxies().getRepository().create(id, (RepositoryObject)this.getFactory().configurationItem(ci.getType(), ci.getProperties()));
            return this.checkForValidations(response);
        }
    }

    public void delete(String id) {
        try {
            this.getRepositoryClient().delete(id);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)String.format("delete fails %s", id));
        }
    }

    public RepositoryObject get(String ciId) {
        Response response = this.getProxies().getRepository().read(ciId);
        return this.checkForValidations(response);
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject ci = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !ci.getValidations().isEmpty()) {
            throw new IllegalStateException(String.format("Configuration item contained validation errors: {%s}", ci.getValidations()));
        }
        return ci;
    }

    public RepositoryObject importPackage(File darFile) {
        return this.getDeployitClient().importPackage(darFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deployAndWait(String source, String target, List<MappingItem> mappings) {
        RepositoryObject[] generatedMappings = this.generateMappings(source, target, mappings);
        target = this.computeRealTarget(source, target);
        this.logger.info((CharSequence)("  real target is " + target));
        String previousDeployedPackage = this.getPreviousDeployedPackage(target);
        String taskId = null;
        try {
            taskId = this.prepareDeployment(source, target, generatedMappings);
            if (taskId == null) {
                throw new RuntimeException("Prepare deployemend failed");
            }
            if (this.testMode) {
                this.logger.info((CharSequence)"Test mode, skip all the steps");
                this.getDeployitClient().skipSteps(taskId, this.range(1, this.getDeployitClient().retrieveTaskInfo(taskId).getNrOfSteps() + 1));
            }
            this.logger.info((CharSequence)("Start deployment task " + taskId));
            this.getDeployitClient().startTaskAndWait(taskId);
            this.checkTaskState(taskId);
        }
        catch (DeployitClientException e) {
            this.logger.error((CharSequence)(" DeployitClientException: " + e.getMessage()));
            if (!e.getMessage().contains("The mappings did not lead to any steps")) {
                throw e;
            }
        }
        finally {
            if (taskId != null) {
                this.logger.info((CharSequence)(" Cancel task " + taskId));
                this.getDeployitClient().cancelTask(taskId);
            }
        }
        return previousDeployedPackage;
    }

    private String prepareDeployment(String source, String target, RepositoryObject[] mappings) {
        ResponseExtractor responseExtractor;
        RepositoryObjects mappingsDto = new RepositoryObjects();
        if (mappings != null && mappings.length > 0) {
            mappingsDto.setObjects(Arrays.asList(mappings));
        }
        if ((responseExtractor = new ResponseExtractor(this.getProxies().getDeployment().validate(source, target, mappingsDto))).isValidResponse()) {
            Steps steps = (Steps)new ResponseExtractor(this.getProxies().getDeployment().prepare(source, target, mappingsDto)).getEntity();
            return steps.getTaskId();
        }
        RepositoryObjects validated = (RepositoryObjects)responseExtractor.getEntity();
        String errMsg = "";
        Iterator i$ = validated.getObjects().iterator();
        if (i$.hasNext()) {
            RepositoryObject v = (RepositoryObject)i$.next();
            if (!v.getValidations().isEmpty()) {
                String msg = String.format("mapping with id %s has the following validation errors %s", v.getId(), v.getValidations());
                this.logger.error((CharSequence)msg);
                errMsg = errMsg + msg + "\n";
            }
            throw new RuntimeException("Mapping validation errors, " + (StringUtils.isNotBlank((String)errMsg) ? errMsg : validated.toString()));
        }
        return null;
    }

    private String getPreviousDeployedPackage(String target) {
        try {
            RepositoryObject dp = this.getRepositoryClient().read(target);
            Map values = dp.getValues();
            Object source = values.get("source");
            return source == null ? null : source.toString();
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)("previous deployed package " + target + " not found"), (Throwable)e);
            return null;
        }
    }

    private String computeRealTarget(String source, String target) {
        String deployedApplicationId = target + "/" + StringUtils.split((String)source, (String)"/")[1];
        this.logger.info((CharSequence)("  deployedApplicationId " + deployedApplicationId));
        for (String d : this.getRepositoryClient().search("Deployment")) {
            if (!d.equals(deployedApplicationId)) continue;
            return deployedApplicationId;
        }
        return target;
    }

    public void undeployAndWait(String source) {
        this.deployAndWait(source, null, null);
    }

    private RepositoryObject[] generateMappings(String source, String target, List<MappingItem> mappings) {
        RepositoryObject[] generatedMappings;
        Object middlewareResources;
        if (target == null) {
            return null;
        }
        if (mappings == null) {
            mappings = Lists.newArrayList();
        }
        RepositoryObject dp = this.getRepositoryClient().read(source);
        Map values = dp.getValues();
        ArrayList deployableArtifacts = Lists.newArrayList();
        Object artifacts = values.get("deployableArtifacts");
        if (artifacts != null) {
            deployableArtifacts.addAll((Collection)artifacts);
        }
        if ((middlewareResources = values.get("middlewareResources")) != null) {
            deployableArtifacts.addAll((Collection)middlewareResources);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)((Object)deployableArtifacts).toString());
        }
        this.logger.info((CharSequence)String.format("generate mappings %s - %s", source, target));
        for (RepositoryObject repositoryObjectMapping : generatedMappings = this.getDeployitClient().generateMappings((List)deployableArtifacts, target)) {
            this.logger.info((CharSequence)("  process generated mapping " + repositoryObjectMapping.getId()));
            this.logger.debug((CharSequence)("   mapping id ->" + repositoryObjectMapping.getId()));
            Map mappingValues = repositoryObjectMapping.getValues();
            MappingItem configuredMapping = this.searchCandidateMapping(mappings, mappingValues);
            if (configuredMapping == null) continue;
            this.logger.debug((CharSequence)("   found a configured mapping " + configuredMapping));
            for (Map.Entry<String, Object> entry : configuredMapping.getProperties().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.logger.debug((CharSequence)("Key " + key));
                this.logger.debug((CharSequence)("Value " + value));
                this.logger.debug((CharSequence)String.format("%s %s with %s", mappings.contains(key) ? "overwrite" : "set", key, value));
                mappingValues.put(key, value);
            }
            List<Map<String, String>> configuredMappingKeyValuePairs = configuredMapping.getKeyValuePairs();
            if (configuredMappingKeyValuePairs != null) {
                Object keyValuePairsFromMapping = mappingValues.get("keyValuePairs");
                this.logger.debug((CharSequence)("replace kvPair " + keyValuePairsFromMapping + " by " + configuredMappingKeyValuePairs));
                mappingValues.put("keyValuePairs", configuredMappingKeyValuePairs);
            }
            this.logger.info((CharSequence)("   modified mapping  " + repositoryObjectMapping));
        }
        return generatedMappings;
    }

    private MappingItem searchCandidateMapping(List<MappingItem> mappings, Map<String, Object> mappingValues) {
        String targetMapping;
        final String sourceMapping = (String)mappingValues.get("source");
        Collection foundMappings = Collections2.filter(mappings, (Predicate)new Predicate<MappingItem>(targetMapping = (String)mappingValues.get("target")){
            final /* synthetic */ String val$targetMapping;
            {
                this.val$targetMapping = string2;
            }

            public boolean apply(MappingItem mappingItem) {
                if (mappingItem == null) {
                    return false;
                }
                return mappingItem.equals(sourceMapping, this.val$targetMapping);
            }
        });
        if (foundMappings.isEmpty()) {
            this.logger.debug((CharSequence)String.format("   found 0 mapping for source (%s) and target (%s) in mappings (%s) ", sourceMapping, targetMapping, mappings));
            return null;
        }
        if (foundMappings.size() > 1) {
            throw new IllegalStateException(String.format("found %n mappings which are candidate for source (%s) and target (%s) : %s", foundMappings.size(), sourceMapping, targetMapping, foundMappings.toString()));
        }
        MappingItem foundMapping = (MappingItem)foundMappings.iterator().next();
        this.logger.debug((CharSequence)String.format("   found 1 mapping for source (%s) and target (%s) : ", sourceMapping, targetMapping, foundMapping));
        return foundMapping;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    private void checkTaskState(String taskId) {
        TaskInfo taskInfo = this.getDeployitClient().retrieveTaskInfo(taskId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.logger.info((CharSequence)String.format("%s Label      %s", taskId, taskInfo.getLabel()));
        this.logger.info((CharSequence)String.format("%s State      %s %d/%d", taskId, taskInfo.getState(), taskInfo.getCurrentStepNr(), taskInfo.getNrOfSteps()));
        GregorianCalendar startDate = (GregorianCalendar)taskInfo.getStartDate();
        GregorianCalendar completionDate = (GregorianCalendar)taskInfo.getCompletionDate();
        this.logger.info((CharSequence)String.format("%s Start      %s", taskId, sdf.format(startDate.getTime())));
        this.logger.info((CharSequence)String.format("%s Completion %s", taskId, sdf.format(completionDate.getTime())));
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= taskInfo.getNrOfSteps(); ++i) {
            Response stepInfoResponse = this.getProxies().getTaskRegistry().getStepInfo(taskId, i, null);
            StepInfo stepInfo = (StepInfo)new ResponseExtractor(stepInfoResponse).getEntity();
            String description = stepInfo.getDescription();
            String log = stepInfo.getLog();
            String stepInfoMessage = StringUtils.isEmpty((String)log) || description.equals(log) ? String.format("%s step #%d %s\t%s", taskId, i, stepInfo.getState(), description) : String.format("%s step #%d %s\t%s\n%s", taskId, i, stepInfo.getState(), description, log);
            this.logger.info((CharSequence)stepInfoMessage);
            if (!"FAILED".endsWith(stepInfo.getState())) continue;
            sb.append(stepInfoMessage);
        }
        if ("STOPPED".equals(taskInfo.getState())) {
            throw new IllegalStateException(String.format("Errors when executing task %s: %s", taskId, sb));
        }
    }

    public void setSkipStepsMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void toggleSkipStepsMode() {
        this.testMode = !this.testMode;
    }

    private Integer[] range(int begin, int end) {
        Integer[] result = new Integer[end - begin];
        for (int i = begin; i < end; ++i) {
            result[i - begin] = i;
        }
        return result;
    }

    Proxies getProxies() {
        return this.proxies;
    }

    ObjectFactory getFactory() {
        return this.factory;
    }

    RepositoryClient getRepositoryClient() {
        return this.repositoryClient;
    }

    DeployitClient getDeployitClient() {
        return this.deployitClient;
    }
}

