/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.maven.ConfigurationItem;
import java.util.List;
import java.util.Map;

public class MappingItem
extends ConfigurationItem {
    private static final List<String> SKIPPED_ITEMS = Lists.newArrayList((Object[])new String[]{"keyValuePairs", "source", "target", "label"});
    private String source;
    private String target;
    private List<Map<String, String>> keyValuePairs;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public String getLabel() {
        return '\"' + this.source + " to " + this.target + '\"';
    }

    @Override
    public void addParameter(String name, Object value) {
        if (SKIPPED_ITEMS.contains(name)) {
            return;
        }
        super.addParameter(name, value);
    }

    public void setKeyValuePairs(List<Map<String, String>> keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    public List<Map<String, String>> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public boolean equals(String sourceMapping, String targetMapping) {
        return this.getSource().equals(sourceMapping) && this.getTarget().equals(targetMapping);
    }

    @Override
    public String toString() {
        return String.format("MappingItem(%s,%s,%s)", this.source, this.target, this.getProperties().toString());
    }
}

