/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.cli;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.cli.api.internal.ImportHelper;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.ImportablePackages;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.maven.cli.MavenProxies;
import java.util.List;

public class DeployitClient {
    private final MavenProxies proxies;

    public DeployitClient(MavenProxies proxies) {
        this.proxies = proxies;
    }

    public RepositoryObject importPackage(String importablePackageName) {
        return ImportHelper.doImport((ImportablePackageProxy)this.proxies.getImportablePackage(), (String)importablePackageName);
    }

    public List<String> listImportablePackages() {
        return ((ImportablePackages)new ResponseExtractor(this.proxies.getImportablePackage().list()).getEntity()).getFiles();
    }

    public TaskInfo retrieveTaskInfo(String taskId) {
        return (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
    }

    public void stopTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().stop(taskId));
    }

    public void startTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().start(taskId));
    }

    public void startTaskAndWait(String taskId) {
        this.startTask(taskId);
        boolean done = false;
        TaskInfo ti = null;
        while (!done) {
            ti = (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
            String st = ti.getState();
            if ("DONE".equals(st) || "ABORTED".equals(st) || "STOPPED".equals(st)) {
                done = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void abortTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().abort(taskId));
    }

    public void cancelTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().cancel(taskId));
    }

    public void skipSteps(String taskId, Integer[] stepIds) {
        String ids = Joiner.on((String)",").join((Object[])stepIds);
        new ResponseExtractor(this.proxies.getTaskRegistry().toggleSkipSteps(taskId, ids));
    }
}

