/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.packager;

import com.xebialabs.deployit.maven.DeployableArtifactItem;
import com.xebialabs.deployit.maven.MiddlewareResource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class ManifestPackager {
    public static final String DEPLOYMENT_PACKAGE_DIR = "deployment-package";
    private final File targetDirectory;
    private final Manifest manifest = new Manifest();
    private boolean generateManifestOnly = false;
    private Log log;
    private final File outputDirectory;
    private MavenProject project;
    private boolean timestampedVersion;
    static final String APPLICATION = "CI-Application";
    static final String VERSION = "CI-Version";

    public ManifestPackager(MavenProject project) {
        this.project = project;
        this.outputDirectory = new File(project.getBuild().getDirectory());
        this.targetDirectory = new File(this.outputDirectory, DEPLOYMENT_PACKAGE_DIR + File.separator + project.getArtifactId() + File.separator + project.getVersion());
        this.targetDirectory.mkdirs();
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() {
        String pomVersion;
        Attributes mainAttributes = this.manifest.getMainAttributes();
        mainAttributes.putValue("Manifest-Version", "1.0");
        mainAttributes.putValue("Deployit-Package-Format-Version", "1.2");
        mainAttributes.putValue(APPLICATION, this.project.getArtifactId());
        String darVersion = pomVersion = this.project.getVersion();
        if (this.timestampedVersion) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
            darVersion = pomVersion + "-" + dateFormat.format(System.currentTimeMillis());
            darVersion = darVersion.replace("-SNAPSHOT", "");
        }
        mainAttributes.putValue(VERSION, darVersion);
        File meta_inf = new File(this.targetDirectory, "META-INF");
        meta_inf.mkdirs();
        File manifestFile = new File(meta_inf, "MANIFEST.MF");
        this.getLog().info((CharSequence)("Generate manifest file " + manifestFile.getAbsolutePath()));
        FileOutputStream fos = null;
        try {
            this.dumpManifest();
            fos = new FileOutputStream(manifestFile);
            this.manifest.write(fos);
        }
        catch (IOException e) {
            try {
                new RuntimeException("generation of the manifest file failed", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpManifest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.manifest.write(baos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
        }
        this.getLog().debug((CharSequence)new String(baos.toByteArray()));
    }

    protected void addDeployableArtifact(DeployableArtifactItem item) {
        File locationTargetDirs;
        this.getLog().info((CharSequence)(" add deployable artifact : " + item));
        if ("Dar".equalsIgnoreCase(item.getType())) {
            return;
        }
        if ("Pom".equalsIgnoreCase(item.getType())) {
            return;
        }
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        File location = new File(item.getFileSystemLocation());
        attributes.putValue("CI-Type", item.getType());
        if (item.hasName()) {
            attributes.putValue("CI-Name", item.getName());
        }
        entries.put(item.getEntryKey(), attributes);
        File targetDir = new File(this.targetDirectory, item.getDarLocation());
        if (this.generateManifestOnly) {
            this.getLog().info((CharSequence)("Skip copying artifact " + item.getName() + " to " + targetDir));
            return;
        }
        targetDir.mkdirs();
        if (location.isAbsolute() || location.getParent() == null) {
            locationTargetDirs = targetDir;
        } else {
            locationTargetDirs = new File(targetDir, location.getParent());
            locationTargetDirs.mkdirs();
        }
        try {
            if (location.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)location, (File)locationTargetDirs);
            } else {
                FileUtils.copyFileToDirectory((File)location, (File)locationTargetDirs);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to copy of " + location + " to " + targetDir, e);
        }
    }

    protected void addMiddlewareResource(MiddlewareResource mr) {
        this.getLog().info((CharSequence)(" add mddleware resource : " + mr.getConfigurationName()));
        Map<String, Attributes> entries = this.manifest.getEntries();
        Attributes attributes = new Attributes();
        attributes.putValue("CI-Type", mr.getType());
        for (Map.Entry<String, String> entry : mr.getProperties().entrySet()) {
            attributes.putValue("CI-" + entry.getKey(), entry.getValue());
        }
        entries.put(mr.getEntryKey(), attributes);
    }

    public boolean isGenerateManifestOnly() {
        return this.generateManifestOnly;
    }

    public void setGenerateManifestOnly(boolean generateManifestOnly) {
        this.generateManifestOnly = generateManifestOnly;
    }

    public File getManifestFile() {
        return new File(this.targetDirectory, "META-INF/MANIFEST.MF");
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Log getLog() {
        return this.log;
    }

    protected DeployableArtifactItem getRealDeployableArtifact(DeployableArtifactItem item) {
        if (!this.isMavenDependency(item)) {
            this.getLog().info((CharSequence)(" add a deployable artifact " + item));
            String relativeLocation = item.getLocation();
            File fileSysLoca = new File(this.project.getBasedir(), relativeLocation);
            this.getLog().debug((CharSequence)("  filesystem location is " + fileSysLoca.getPath()));
            item.setFileSystemLocation(fileSysLoca.getPath());
            return item;
        }
        this.getLog().info((CharSequence)(" add a maven deployable artifact " + item));
        this.getLog().debug((CharSequence)("-translateIntoPath- " + item.getLocation()));
        String key = item.getLocation();
        Artifact artifact = (Artifact)this.project.getArtifactMap().get(key);
        if (artifact == null) {
            this.getLog().debug((CharSequence)("key (" + key + ") Not found, search in the dependency artifacts..."));
        }
        for (Object o : this.project.getDependencyArtifacts()) {
            Artifact da = (Artifact)o;
            String artifactKey = da.getGroupId() + ":" + da.getArtifactId();
            this.log.debug((CharSequence)("   check dependency " + artifactKey));
            if (!artifactKey.equals(key)) continue;
            artifact = da;
        }
        if (artifact == null) {
            throw new IllegalStateException("The artifact " + key + " referenced in plugin as is not found the project dependencies " + this.project.getDependencyArtifacts());
        }
        File file = artifact.getFile();
        if (file == null) {
            throw new IllegalStateException("Associated file of " + artifact + " is empty");
        }
        this.log.debug((CharSequence)("  artifact file of " + artifact + " : " + file));
        String artifactFile = file.toString();
        DeployableArtifactItem mavenDeployableArtifact = new DeployableArtifactItem();
        mavenDeployableArtifact.setLocation(artifactFile);
        mavenDeployableArtifact.setFileSystemLocation(artifactFile);
        if (item.hasName()) {
            mavenDeployableArtifact.setName(item.getName());
        } else {
            mavenDeployableArtifact.setName(artifact.getArtifactId());
        }
        mavenDeployableArtifact.setType(item.getType());
        mavenDeployableArtifact.setDarLocation(item.getDarLocation());
        mavenDeployableArtifact.setFolder(item.isFolder());
        return mavenDeployableArtifact;
    }

    private boolean isMavenDependency(DeployableArtifactItem item) {
        return item.getLocation().contains(":") && item.getLocation().indexOf(58) > 1;
    }

    public DeployableArtifactItem getRealDeployableArtifact(Artifact artifact) {
        DeployableArtifactItem mavenDeployableArtifact = new DeployableArtifactItem();
        mavenDeployableArtifact.setName(artifact.getArtifactId());
        mavenDeployableArtifact.setType(this.capitalize(artifact.getType()));
        File file = artifact.getFile();
        if (file != null) {
            mavenDeployableArtifact.setFileSystemLocation(file.toString());
            mavenDeployableArtifact.setLocation(file.toString());
        }
        return mavenDeployableArtifact;
    }

    private String capitalize(String inputWord) {
        String firstLetter = inputWord.substring(0, 1);
        String remainder = inputWord.substring(1);
        String capitalized = firstLetter.toUpperCase() + remainder.toLowerCase();
        return capitalized;
    }

    public void addDeployableArtifact(Artifact artifact) {
        this.addDeployableArtifact(this.getRealDeployableArtifact(artifact));
    }

    public void addDeployableArtifacts(List<DeployableArtifactItem> deployableArtifacts) {
        if (deployableArtifacts == null) {
            return;
        }
        this.getLog().info((CharSequence)"Add the artifacts");
        for (DeployableArtifactItem item : deployableArtifacts) {
            this.addDeployableArtifact(this.getRealDeployableArtifact(item));
        }
    }

    public void addMiddlewareResources(List<MiddlewareResource> middlewareResources) {
        if (middlewareResources == null) {
            return;
        }
        this.getLog().info((CharSequence)"Add the middleware resources");
        for (MiddlewareResource mr : middlewareResources) {
            this.addMiddlewareResource(mr);
        }
    }

    public void seal() throws MojoExecutionException {
        if (this.generateManifestOnly) {
            this.getLog().info((CharSequence)"Do not seal the dar file, return now");
            return;
        }
        try {
            File darFile = this.getDarFile();
            this.getLog().info((CharSequence)("Seal the archive in " + darFile));
            MavenArchiver mvnArchiver = new MavenArchiver();
            mvnArchiver.setArchiver(new JarArchiver());
            mvnArchiver.setOutputFile(darFile);
            mvnArchiver.getArchiver().addDirectory(this.getTargetDirectory());
            File manifestFile = this.getManifestFile();
            this.getLog().debug((CharSequence)("set Manifest file of the archive " + manifestFile));
            mvnArchiver.getArchiver().setManifest(manifestFile);
            mvnArchiver.createArchive(this.project, new MavenArchiveConfiguration());
            this.project.getArtifact().setFile(darFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling DAR", e);
        }
    }

    public File getDarFile() {
        return new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".dar");
    }

    public void setTimestampedVersion(boolean timestampedVersion) {
        this.timestampedVersion = timestampedVersion;
    }
}

