/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.cli;

import com.google.common.base.Joiner;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.maven.cli.ImportHelper;
import com.xebialabs.deployit.maven.cli.MavenProxies;
import com.xebialabs.deployit.maven.cli.ResponseExtractor;

public class DeployitClient {
    private final MavenProxies proxies;

    public DeployitClient(MavenProxies proxies) {
        this.proxies = proxies;
    }

    public RepositoryObject importPackage(String importablePackageName) {
        return new ImportHelper().doImport(this.proxies.getAuthentication().getHttpClient(), this.proxies.getHost(), importablePackageName);
    }

    public TaskInfo retrieveTaskInfo(String taskId) {
        return (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
    }

    public void stopTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().stop(taskId));
    }

    public void startTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().start(taskId));
    }

    public void startTaskAndWait(String taskId) {
        this.startTask(taskId);
        boolean done = false;
        TaskInfo ti = null;
        while (!done) {
            ti = (TaskInfo)new ResponseExtractor(this.proxies.getTaskRegistry().getTaskInfo(taskId)).getEntity();
            String st = ti.getState();
            if ("DONE".equals(st) || "ABORTED".equals(st) || "STOPPED".equals(st)) {
                done = true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void abortTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().abort(taskId));
    }

    public void cancelTask(String taskId) {
        new ResponseExtractor(this.proxies.getTaskRegistry().cancel(taskId));
    }

    public void skipSteps(String taskId, Integer[] stepIds) {
        String ids = Joiner.on((String)",").join((Object[])stepIds);
        new ResponseExtractor(this.proxies.getTaskRegistry().toggleSkipSteps(taskId, ids));
    }
}

