/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.maven.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemDto;
import com.xebialabs.deployit.core.api.dto.Deployment;
import com.xebialabs.deployit.core.api.dto.Message;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.core.api.dto.StepInfo;
import com.xebialabs.deployit.core.api.dto.TaskInfo;
import com.xebialabs.deployit.maven.Container;
import com.xebialabs.deployit.maven.Deployed;
import com.xebialabs.deployit.maven.cli.Authentication;
import com.xebialabs.deployit.maven.cli.DeployitClient;
import com.xebialabs.deployit.maven.cli.DeploymentClient;
import com.xebialabs.deployit.maven.cli.MavenCliOptions;
import com.xebialabs.deployit.maven.cli.MavenProxies;
import com.xebialabs.deployit.maven.cli.RepositoryClient;
import com.xebialabs.deployit.maven.cli.ResponseExtractor;
import com.xebialabs.deployit.maven.cli.ssl.SelfSignedCertificateAcceptingSocketFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class MavenCli {
    private Log logger;
    private MavenCliOptions options;
    private Authentication authentication;
    private MavenProxies proxies;
    private DeploymentClient deploymentClient;
    private DeployitClient deployitClient;
    private RepositoryClient repositoryClient;

    public MavenCli(MavenCliOptions options, Log log) throws Exception {
        this.logger = log;
        this.options = options;
        this.initialize();
    }

    private void initialize() throws Exception {
        this.authentication = this.createCredentials();
        this.setupSecureCommunications();
        this.authentication.init(this.options);
        this.attemptToConnectToServer(this.authentication);
        this.proxies = this.createAndRegisterProxies(this.authentication);
        this.deploymentClient = new DeploymentClient(this.proxies);
        this.deployitClient = new DeployitClient(this.proxies);
        this.repositoryClient = new RepositoryClient(this.proxies);
    }

    private Authentication createCredentials() {
        Authentication authentication = new Authentication();
        authentication.username = this.options.getUsername();
        authentication.password = this.options.getPassword();
        return authentication;
    }

    private void setupSecureCommunications() {
        if (this.options.isSecured()) {
            Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)new SelfSignedCertificateAcceptingSocketFactory(), 443);
            Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        }
    }

    private MavenProxies createAndRegisterProxies(Authentication client) {
        return new MavenProxies(this.options, client);
    }

    private void attemptToConnectToServer(Authentication authentication) {
        String urlToConnectTo = this.options.getUrl();
        this.logger.info((CharSequence)("Connecting to the Deployit server at " + urlToConnectTo + "..."));
        try {
            int responseCode = authentication.getHttpClient().executeMethod((HttpMethod)new GetMethod(urlToConnectTo + "/server/info"));
            if (responseCode != 200) {
                if (responseCode == 401 || responseCode == 403) {
                    throw new IllegalStateException("You were not authenticated correctly, did you use the correct credentials?");
                }
                throw new IllegalStateException("Could contact the server at " + urlToConnectTo + " but received an HTTP error code, " + responseCode);
            }
            this.logger.info((CharSequence)"Succesfully connected.");
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, mue);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not contact the server at " + urlToConnectTo, e);
        }
    }

    public RepositoryObject create(Container ci) {
        String id = ci.getId();
        try {
            return this.get(id);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)String.format("%s does not exist, create it", id));
            ConfigurationItemDto configurationItem = new ConfigurationItemDto(id, ci.getType());
            configurationItem.setValues((Map)Maps.newHashMap(ci.getProperties()));
            Response response = this.getProxies().getRepository().create(configurationItem.getId(), configurationItem);
            return this.checkForValidations(response);
        }
    }

    public void delete(String id) {
        try {
            this.logger.debug((CharSequence)("Delete " + id));
            this.repositoryClient.delete(id);
        }
        catch (Exception e) {
            this.logger.debug((CharSequence)String.format("delete fails %s", id));
        }
    }

    public RepositoryObject get(String ciId) {
        Response response = this.getProxies().getRepository().read(ciId);
        return this.checkForValidations(response);
    }

    private RepositoryObject checkForValidations(Response response) {
        ResponseExtractor responseExtractor = new ResponseExtractor(response);
        RepositoryObject ci = (RepositoryObject)responseExtractor.getEntity();
        if (!responseExtractor.isValidResponse() && !ci.getValidations().isEmpty()) {
            throw new IllegalStateException(String.format("Configuration item contained validation errors: {%s}", ci.getValidations()));
        }
        return ci;
    }

    public RepositoryObject importPackage(File darFile) {
        return this.deployitClient.importPackage(darFile.getPath());
    }

    public String deploy(String source, String target, List<Deployed> configuredDeployeds) {
        Deployment deployment;
        String previouslyDeployedApplicationId = null;
        boolean initialDeployment = this.isInitialDeployment(source, target);
        if (initialDeployment) {
            this.logger.info((CharSequence)"initial Deployment");
            deployment = this.deploymentClient.prepareInitial(source, target);
        } else {
            this.logger.info((CharSequence)"upgrade Deployment");
            String deployedApplicationId = this.getDeployedApplicationId(source, target);
            previouslyDeployedApplicationId = this.getPreviousDeployedPackage(deployedApplicationId);
            deployment = this.deploymentClient.prepareUpgrade(source, deployedApplicationId);
        }
        if (this.options.isExplicitMappings()) {
            this.logger.debug((CharSequence)"use explicits deployeds");
            for (Deployed configuredDeployed : configuredDeployeds) {
                Preconditions.checkNotNull((Object)configuredDeployed.getId(), (Object)"id is mandatory in the explicit deployed mode");
                String type = configuredDeployed.getType();
                Preconditions.checkNotNull((Object)type, (Object)"type is mandatory in the explicit deployed mode");
                String deployableId = configuredDeployed.getDeployable(source);
                String containerId = configuredDeployed.getContainer();
                this.logger.debug((CharSequence)String.format(" generateSingleDeployed %s %s %s", deployableId, containerId, type));
                deployment = this.deploymentClient.generateSingleDeployed(deployableId, containerId, type, deployment);
            }
        } else {
            this.logger.debug((CharSequence)"generateAllDeployeds");
            deployment = this.deploymentClient.generateAllDeployeds(deployment);
        }
        if (configuredDeployeds != null) {
            this.logger.debug((CharSequence)"update the generated deployeds with the configured deployeds");
            for (ConfigurationItemDto configurationItem : deployment.getDeployeds()) {
                final String id = configurationItem.getId();
                try {
                    Deployed deployed = (Deployed)Iterables.find(configuredDeployeds, (Predicate)new Predicate<Deployed>(){

                        public boolean apply(Deployed input) {
                            return input.getId().equals(id);
                        }
                    });
                    this.updateConfigurationItemValues(configurationItem, deployed);
                }
                catch (NoSuchElementException nsee) {
                    this.logger.debug((CharSequence)(" no configured deployed found with id " + configurationItem.getId()));
                }
            }
        }
        try {
            this.logger.debug((CharSequence)"validate");
            deployment = this.deploymentClient.validate(deployment);
        }
        catch (RuntimeException e) {
            this.logger.error((CharSequence)(" RuntimeException: " + e.getMessage()));
            if (this.options.isFailIfNoStepsAreGenerated() || !e.getMessage().contains("The task did not deliver any steps")) {
                throw e;
            }
            return null;
        }
        int validationMessagesFound = 0;
        for (ConfigurationItemDto configurationItem : deployment.getDeployeds()) {
            for (Message msg : configurationItem.getValidations()) {
                this.logger.error((CharSequence)String.format("Validation error found on '%s' on field '%s': %s, %s", configurationItem.getId(), msg.getField(), msg.getMessage(), configurationItem));
                this.logger.error((CharSequence)String.format(" %s", configurationItem));
                ++validationMessagesFound;
            }
        }
        if (validationMessagesFound > 0) {
            throw new IllegalStateException(String.format("Validation errors (%d) have been found", validationMessagesFound));
        }
        this.logger.debug((CharSequence)"deploy");
        this.executeTask(this.deploymentClient.deploy(deployment).getTaskId());
        return previouslyDeployedApplicationId;
    }

    private void updateConfigurationItemValues(ConfigurationItemDto configurationItem, Deployed configuredDeployed) {
        this.logger.debug((CharSequence)String.format(" update values of %s with %s", configuredDeployed.getId(), configuredDeployed.getValues()));
        configurationItem.getValues().putAll(configuredDeployed.getValues());
        if (!configuredDeployed.getPlaceholders().isEmpty()) {
            if (!configurationItem.getValues().containsKey("placeholders")) {
                configurationItem.getValues().put("placeholders", new HashMap());
            }
            Map placeholders = (Map)configurationItem.getValues().get("placeholders");
            placeholders.putAll(configuredDeployed.getPlaceholders());
        }
        this.logger.debug((CharSequence)configurationItem.getValues().toString());
    }

    public void undeployAndWait(String source) {
        this.logger.info((CharSequence)("   undeployAndWait " + source));
        String taskId = this.deploymentClient.undeploy(source).getTaskId();
        this.executeTask(taskId);
    }

    private boolean executeTask(String taskId) {
        if (this.options.isSkipMode()) {
            this.logger.info((CharSequence)"skip mode, skip all the steps");
            this.getDeployitClient().skipSteps(taskId, this.range(1, this.getDeployitClient().retrieveTaskInfo(taskId).getNrOfSteps() + 1));
        }
        this.checkTaskState(taskId);
        if (this.options.isTestMode()) {
            this.logger.info((CharSequence)("test mode, cancel task " + taskId));
            this.getDeployitClient().cancelTask(taskId);
            return false;
        }
        try {
            this.logger.info((CharSequence)("Start deployment task " + taskId));
            this.getDeployitClient().startTaskAndWait(taskId);
            this.checkTaskState(taskId);
            return true;
        }
        catch (RuntimeException e) {
            if (taskId != null) {
                this.logger.info((CharSequence)String.format("on Error (%s), cancel task %s", e.getMessage(), taskId));
                this.getDeployitClient().cancelTask(taskId);
            }
            throw e;
        }
    }

    private boolean isInitialDeployment(String source, String target) {
        String deployedApplicationId = this.getDeployedApplicationId(source, target);
        this.logger.debug((CharSequence)("  deployedApplicationId " + deployedApplicationId));
        try {
            this.get(deployedApplicationId);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private String getDeployedApplicationId(String source, String target) {
        return target + "/" + StringUtils.split((String)source, (String)"/")[1];
    }

    private String getPreviousDeployedPackage(String target) {
        RepositoryObject dp = this.repositoryClient.read(target);
        Map values = dp.getValues();
        Object source = values.get("version");
        return source == null ? null : source.toString();
    }

    private void checkTaskState(String taskId) {
        TaskInfo taskInfo = this.getDeployitClient().retrieveTaskInfo(taskId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss");
        this.logger.info((CharSequence)String.format("%s Label      %s", taskId, taskInfo.getLabel()));
        this.logger.info((CharSequence)String.format("%s State      %s %d/%d", taskId, taskInfo.getState(), taskInfo.getCurrentStepNr(), taskInfo.getNrOfSteps()));
        if (taskInfo.getStartDate() != null) {
            GregorianCalendar startDate = (GregorianCalendar)taskInfo.getStartDate();
            this.logger.info((CharSequence)String.format("%s Start      %s", taskId, sdf.format(startDate.getTime())));
        }
        if (taskInfo.getCompletionDate() != null) {
            GregorianCalendar completionDate = (GregorianCalendar)taskInfo.getCompletionDate();
            this.logger.info((CharSequence)String.format("%s Completion %s", taskId, sdf.format(completionDate.getTime())));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= taskInfo.getNrOfSteps(); ++i) {
            Response stepInfoResponse = this.getProxies().getTaskRegistry().getStepInfo(taskId, i, null);
            StepInfo stepInfo = (StepInfo)new ResponseExtractor(stepInfoResponse).getEntity();
            String description = stepInfo.getDescription();
            String log = stepInfo.getLog();
            String stepInfoMessage = StringUtils.isEmpty((String)log) || description.equals(log) ? String.format("%s step #%d %s\t%s", taskId, i, stepInfo.getState(), description) : String.format("%s step #%d %s\t%s\n%s", taskId, i, stepInfo.getState(), description, log);
            this.logger.info((CharSequence)stepInfoMessage);
            if (!"FAILED".endsWith(stepInfo.getState())) continue;
            sb.append(stepInfoMessage);
        }
        if ("STOPPED".equals(taskInfo.getState())) {
            throw new IllegalStateException(String.format("Errors when executing task %s: %s", taskId, sb));
        }
    }

    private Integer[] range(int begin, int end) {
        Integer[] result = new Integer[end - begin];
        for (int i = begin; i < end; ++i) {
            result[i - begin] = i;
        }
        return result;
    }

    private DeployitClient getDeployitClient() {
        return this.deployitClient;
    }

    private DeploymentClient getDeploymentClient() {
        return this.deploymentClient;
    }

    private MavenProxies getProxies() {
        return this.proxies;
    }
}

