package com.xebialabs.deployit.maven;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;

import java.util.LinkedList;
import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Lists.newLinkedList;
import static java.lang.String.format;

public class Deployed {

	private String id;
	private String type;
	final private Map<String, Object> values = Maps.newHashMap();
	final private Map<String, String> placeholders = Maps.newHashMap();

	public void addValues(String name, Object value) {
		checkNotNull(name);
		if ("placeholders".equals(name))
			return;

		checkNotNull(value, format("null value for %s", name));
		if ("id".equals(name)) {
			id = value.toString();
			return;
		}

		if ("type".equals(name)) {
			type = value.toString();
			return;
		}

		values.put(name, value);
	}

	public String getContainer() {
		LinkedList<String> split = newLinkedList(Splitter.on("/").split(id));
		split.removeLast();
		return Joiner.on("/").join(split);
	}

	public String getDeployable(String version) {
		LinkedList<String> split = newLinkedList(Splitter.on("/").split(id));
		return Joiner.on("/").join(version, split.removeLast());
	}

	public String getId() {
		return id;
	}

	public String getType() {
		return type;
	}

	public Map<String, Object> getValues() {
		return values;
	}

	public void addPlaceholder(String key, String value) {
		placeholders.put(key, value);
	}

	public Map<String, String> getPlaceholders() {
		return placeholders;
	}

	@Override
	public String toString() {
		return "Deployed{" +
				"id='" + id + '\'' +
				", type='" + type + '\'' +
				", values=" + values +
				", placeholders=" + placeholders +
				'}';
	}
}
