package com.xebialabs.deployit.maven.cli;

import static java.lang.String.format;

public class MavenCliOptions {

	static final int DEFAULT_DEPLOYIT_SERVER_PORT = 4516;
	static final int DEFAULT_DEPLOYIT_SERVER_SECURE_PORT = 4517;
	static final String DEFAULT_DEPLOYIT_SERVER_HOST = "127.0.0.1";
	static final String DEFAULT_USERNAME = "admin";
	static final String DEFAULT_PASSWORD = "admin";

	private boolean secured = false;
	private boolean exposeProxies = false;
	private String host = DEFAULT_DEPLOYIT_SERVER_HOST;
	private int port = -1;
	private String context = "deployit";
	private String username = DEFAULT_USERNAME;
	private String password = DEFAULT_PASSWORD;

	private boolean skipMode = false;
	private boolean testMode = false;

	private boolean failIfNoStepsAreGenerated = false;
	private boolean explicitMappings = false;

	public void setHost(String host) {
		this.host = host;
	}

	public String getHost() {
		return host;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public int getPort() {
		return port == -1 ? (secured ? DEFAULT_DEPLOYIT_SERVER_SECURE_PORT : DEFAULT_DEPLOYIT_SERVER_PORT) : port;
	}

	public boolean isExposeProxies() {
		return exposeProxies;
	}

	public void setExposeProxies(boolean exposeProxies) {
		this.exposeProxies = exposeProxies;
	}

	public String getUsername() {
		return username == null ? DEFAULT_USERNAME : username;
	}

	public void setUsername(final String username) {
		this.username = username;
	}

	public String getPassword() {
		return password == null ? DEFAULT_PASSWORD : password;
	}

	public void setPassword(final String password) {
		this.password = password;
	}

	public boolean isSecured() {
		return secured;
	}

	public void setSecured(boolean secured) {
		this.secured = secured;
	}

	public String getUrl() {
		return format("http%s://%s:%d/%s", secured ? "s" : "", host, getPort(), getContext());
	}

	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	public boolean isSkipMode() {
		return skipMode;
	}

	public void setSkipMode(boolean skipMode) {
		this.skipMode = skipMode;
	}

	public boolean isTestMode() {
		return testMode;
	}

	public void setTestMode(boolean testMode) {
		this.testMode = testMode;
	}

	public boolean isFailIfNoStepsAreGenerated() {
		return failIfNoStepsAreGenerated;
	}

	public void setFailIfNoStepsAreGenerated(boolean failIfNoStepsAreGenerated) {
		this.failIfNoStepsAreGenerated = failIfNoStepsAreGenerated;
	}

	public boolean isExplicitMappings() {
		return explicitMappings;
	}

	public void setExplicitMappings(boolean explicitMappings) {
		this.explicitMappings = explicitMappings;
	}
}
