package com.xebialabs.deployit.maven.cli;

import com.xebialabs.deployit.core.api.dto.RepositoryObject;

public class RepositoryClient {
	private final MavenProxies proxies;

	public RepositoryClient(final MavenProxies proxies) {
		this.proxies = proxies;
	}

	public RepositoryObject read(final String id) {
		return new ResponseExtractor(proxies.getRepository().read(id)).getEntity();
	}

	public void delete(final String id) {
		new ResponseExtractor(proxies.getRepository().delete(id));
	}

}
