package com.xebialabs.deployit.maven;

import com.xebialabs.deployit.client.Deployed;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.lang.String.format;

public class MavenDeployed extends Deployed {

	public void addValues(String name, Object value) {
		checkNotNull(name);
		if ("placeholders".equals(name))
			return;

		checkNotNull(value, format("null value for %s", name));
		if ("id".equals(name)) {
			id = value.toString();
			return;
		}

		if ("type".equals(name)) {
			type = value.toString();
			return;
		}
		values.put(name, value);
	}

}
